/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.code;

import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.comate.code.FunctionCallChainKt;
import org.archguard.comate.code.Leaf;
import org.archguard.comate.code.NodeTree;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJD\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H\u0002J(\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/archguard/comate/code/FunctionCallChain;", "", "()V", "loopCount", "", "maxLoopCount", "analysis", "Lorg/archguard/comate/code/NodeTree;", "funcName", "", "structs", "", "Lchapi/domain/core/CodeDataStruct;", "buildCallChain", "Lorg/archguard/comate/code/Leaf;", "methodMap", "", "diMap", "buildMethodMap", "comate-core"})
@SourceDebugExtension(value={"SMAP\nFunctionCallChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionCallChain.kt\norg/archguard/comate/code/FunctionCallChain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1855#2,2:97\n*S KotlinDebug\n*F\n+ 1 FunctionCallChain.kt\norg/archguard/comate/code/FunctionCallChain\n*L\n67#1:97,2\n*E\n"})
public final class FunctionCallChain {
    private int loopCount;
    private int maxLoopCount = 6;

    @NotNull
    public final NodeTree analysis(@NotNull String funcName, @NotNull List<CodeDataStruct> structs) {
        Intrinsics.checkNotNullParameter((Object)funcName, (String)"funcName");
        Intrinsics.checkNotNullParameter(structs, (String)"structs");
        Map<String, List<String>> methodMap = this.buildMethodMap(structs);
        List<Leaf> chain = this.buildCallChain(funcName, methodMap, MapsKt.emptyMap());
        return new NodeTree(funcName, chain).removeDuplicate();
    }

    private final Map<String, List<String>> buildMethodMap(List<CodeDataStruct> structs) {
        Map methodMap = new LinkedHashMap();
        for (CodeDataStruct clz : structs) {
            for (CodeFunction method : clz.getFunctions()) {
                String methodName = method.buildFullMethodName(clz);
                methodMap.put(methodName, method.getAllCallString());
            }
        }
        return methodMap;
    }

    private final List<Leaf> buildCallChain(String funcName, Map<String, ? extends List<String>> methodMap, Map<String, String> diMap) {
        if (this.loopCount > this.maxLoopCount) {
            return CollectionsKt.emptyList();
        }
        int n = this.loopCount;
        this.loopCount = n + 1;
        List<String> list = methodMap.get(funcName);
        boolean bl = list != null ? !((Collection)list).isEmpty() : false;
        if (bl) {
            List arrayResult = new ArrayList();
            List<String> list2 = methodMap.get(funcName);
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String child = (String)element$iv;
                    boolean bl2 = false;
                    String childName = diMap.containsKey(FunctionCallChainKt.getClassName(child)) ? diMap.get(FunctionCallChainKt.getClassName(child)) + "." + FunctionCallChainKt.getMethodName(child) : child;
                    List<String> list3 = methodMap.get(child);
                    boolean bl3 = list3 != null ? !((Collection)list3).isEmpty() : false;
                    if (bl3) {
                        CollectionsKt.addAll((Collection)arrayResult, (Iterable)this.buildCallChain(childName, methodMap, diMap));
                    }
                    ((Collection)arrayResult).add(new Leaf(funcName, childName));
                }
            }
            return arrayResult;
        }
        return CollectionsKt.emptyList();
    }
}

