/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.code;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.comate.code.Leaf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/archguard/comate/code/NodeTree;", "", "node", "", "children", "", "Lorg/archguard/comate/code/Leaf;", "(Ljava/lang/String;Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "getNode", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "removeDuplicate", "toString", "comate-core"})
public final class NodeTree {
    @NotNull
    private final String node;
    @NotNull
    private final List<Leaf> children;

    public NodeTree(@NotNull String node, @NotNull List<Leaf> children) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.node = node;
        this.children = children;
    }

    @NotNull
    public final String getNode() {
        return this.node;
    }

    @NotNull
    public final List<Leaf> getChildren() {
        return this.children;
    }

    @NotNull
    public final NodeTree removeDuplicate() {
        Map map = new LinkedHashMap();
        List newChildren = new ArrayList();
        for (Leaf child : this.children) {
            if (map.containsKey(child.getRight())) continue;
            map.put(child.getRight(), child.getLeft());
            newChildren.add(child);
        }
        return new NodeTree(this.node, newChildren);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.children, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String component1() {
        return this.node;
    }

    @NotNull
    public final List<Leaf> component2() {
        return this.children;
    }

    @NotNull
    public final NodeTree copy(@NotNull String node, @NotNull List<Leaf> children) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new NodeTree(node, children);
    }

    public static /* synthetic */ NodeTree copy$default(NodeTree nodeTree, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = nodeTree.node;
        }
        if ((n & 2) != 0) {
            list = nodeTree.children;
        }
        return nodeTree.copy(string, list);
    }

    public int hashCode() {
        int result = this.node.hashCode();
        result = result * 31 + ((Object)this.children).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeTree)) {
            return false;
        }
        NodeTree nodeTree = (NodeTree)other;
        if (!Intrinsics.areEqual((Object)this.node, (Object)nodeTree.node)) {
            return false;
        }
        return Intrinsics.areEqual(this.children, nodeTree.children);
    }
}

