/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.document;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.comate.document.IntroductionVisitor;
import org.archguard.comate.document.ReadmeIntroduction;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/archguard/comate/document/ReadmeParser;", "", "content", "", "(Ljava/lang/String;)V", "node", "Lorg/commonmark/node/Node;", "parser", "Lorg/commonmark/parser/Parser;", "introduction", "Lorg/archguard/comate/document/ReadmeIntroduction;", "Companion", "comate-core"})
public final class ReadmeParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Parser parser;
    @NotNull
    private final Node node;

    public ReadmeParser(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Parser parser = Parser.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"builder().build()");
        this.parser = parser;
        Node node = this.parser.parse(content);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"parser.parse(content)");
        this.node = node;
    }

    @NotNull
    public final ReadmeIntroduction introduction() {
        IntroductionVisitor visitor = new IntroductionVisitor();
        this.node.accept((Visitor)visitor);
        return visitor.introduction();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/archguard/comate/document/ReadmeParser$Companion;", "", "()V", "introduction", "", "workdir", "Ljava/nio/file/Path;", "comate-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String introduction(@NotNull Path workdir) {
            Intrinsics.checkNotNullParameter((Object)workdir, (String)"workdir");
            Object instr = "";
            String string = ((Object)workdir).toString();
            String[] stringArray = new String[]{"README.md"};
            Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(base, *subpaths)");
            Path readmeFile = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(readmeFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                String readme = PathsKt.readText$default((Path)readmeFile, null, (int)1, null);
                ReadmeParser readmeParser = new ReadmeParser(readme);
                ReadmeIntroduction introduction = readmeParser.introduction();
                instr = "\nProject introduction: " + introduction.getContent() + "\n";
            }
            return instr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

