/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.dynamic.functions;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.action.checkout.ExecuteGitCheckoutKt;
import org.archguard.action.checkout.GitCommandManager;
import org.archguard.action.checkout.GitSourceSettings;
import org.archguard.action.io.FileExt;
import org.archguard.comate.command.ComateContext;
import org.archguard.comate.dynamic.functions.ComateFunction;
import org.archguard.comate.dynamic.functions.DyFunction;
import org.archguard.comate.dynamic.functions.FunctionResult;
import org.jetbrains.annotations.NotNull;

@ComateFunction
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0010j\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e`\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/archguard/comate/dynamic/functions/InitializeSystemFunction;", "Lorg/archguard/comate/dynamic/functions/DyFunction;", "context", "Lorg/archguard/comate/command/ComateContext;", "(Lorg/archguard/comate/command/ComateContext;)V", "getContext", "()Lorg/archguard/comate/command/ComateContext;", "hidden", "", "getHidden", "()Z", "execute", "Lorg/archguard/comate/dynamic/functions/FunctionResult;", "explain", "", "parameters", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "comate-core"})
public final class InitializeSystemFunction
implements DyFunction {
    @NotNull
    private final ComateContext context;

    public InitializeSystemFunction(@NotNull ComateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    public ComateContext getContext() {
        return this.context;
    }

    @Override
    public boolean getHidden() {
        return true;
    }

    @Override
    @NotNull
    public String explain() {
        return "Initialize system will clone the repository and setup it.";
    }

    @NotNull
    public FunctionResult<Boolean> execute() {
        GitSourceSettings settings = new GitSourceSettings(this.getContext().getProjectRepo(), null, null, null, null, false, false, null, 254, null);
        FileExt.INSTANCE.mkdir("temp");
        File workingDirectory = new File("temp", settings.getRepositoryPath());
        String string = workingDirectory.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"workingDirectory.toString()");
        FileExt.INSTANCE.mkdir(string);
        String string2 = workingDirectory.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"workingDirectory.toString()");
        GitCommandManager git = new GitCommandManager(string2, false, 2, null);
        ExecuteGitCheckoutKt.doCheckout((GitCommandManager)git, (GitSourceSettings)settings);
        ComateContext comateContext = this.getContext();
        Path path = Paths.get(workingDirectory.getAbsolutePath().toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
        comateContext.setWorkdir(path);
        return new FunctionResult.Success<Boolean>(true);
    }

    @Override
    @NotNull
    public HashMap<String, String> parameters() {
        return new HashMap<String, String>();
    }

    @Override
    @NotNull
    public String define() {
        return DyFunction.DefaultImpls.define(this);
    }
}

