/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.connector;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.theokanning.openai.OpenAiApi;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionChunk;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.service.OpenAiService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import okhttp3.OkHttpClient;
import org.archguard.comate.connector.LlmConnector;
import org.archguard.comate.connector.OpenAIConnector;
import org.archguard.comate.connector.OpenAIConnectorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/archguard/comate/connector/OpenAIConnector;", "Lorg/archguard/comate/connector/LlmConnector;", "openAiKey", "", "openAiVersion", "openAiProxy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "historyMessageLength", "", "messages", "", "Lcom/theokanning/openai/completion/chat/ChatMessage;", "getMessages", "()Ljava/util/List;", "service", "Lcom/theokanning/openai/service/OpenAiService;", "prompt", "text", "stream", "Lkotlinx/coroutines/flow/Flow;", "llm-core"})
public final class OpenAIConnector
implements LlmConnector {
    @NotNull
    private final String openAiKey;
    @NotNull
    private final String openAiVersion;
    @Nullable
    private final String openAiProxy;
    @NotNull
    private OpenAiService service;
    @NotNull
    private final List<ChatMessage> messages;
    private int historyMessageLength;

    public OpenAIConnector(@NotNull String openAiKey, @NotNull String openAiVersion, @Nullable String openAiProxy) {
        Intrinsics.checkNotNullParameter((Object)openAiKey, (String)"openAiKey");
        Intrinsics.checkNotNullParameter((Object)openAiVersion, (String)"openAiVersion");
        this.openAiKey = openAiKey;
        this.openAiVersion = openAiVersion;
        this.openAiProxy = openAiProxy;
        if (((CharSequence)this.openAiKey).length() == 0) {
            throw new Exception("openAiKey is empty");
        }
        CharSequence charSequence = this.openAiProxy;
        if (charSequence == null || charSequence.length() == 0) {
            this.service = new OpenAiService(this.openAiKey, this.getTimeout());
        } else {
            ObjectMapper mapper = OpenAiService.defaultObjectMapper();
            OkHttpClient client = OpenAiService.defaultClient((String)this.openAiKey, (Duration)this.getTimeout());
            Retrofit retrofit = new Retrofit.Builder().baseUrl(this.openAiProxy).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
            OpenAiApi api = (OpenAiApi)retrofit.create(OpenAiApi.class);
            this.service = new OpenAiService(api);
        }
        this.messages = new ArrayList();
    }

    public /* synthetic */ OpenAIConnector(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = OpenAIConnectorKt.getOPENAI_MODEL()[0];
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        this(string, string2, string3);
    }

    @NotNull
    public final List<ChatMessage> getMessages() {
        return this.messages;
    }

    @Override
    @NotNull
    public String prompt(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ChatMessage systemMessage = new ChatMessage(ChatMessageRole.USER.value(), text);
        this.historyMessageLength += text.length();
        if (this.historyMessageLength > 4096) {
            this.messages.clear();
        }
        this.messages.add(systemMessage);
        ChatCompletionRequest completionRequest = ChatCompletionRequest.builder().model(this.openAiVersion).temperature(Double.valueOf(0.0)).messages(this.messages).build();
        ChatCompletionResult completion = this.service.createChatCompletion(completionRequest);
        String output = ((ChatCompletionChoice)completion.getChoices().get(0)).getMessage().getContent();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        return output;
    }

    @Override
    @NotNull
    public Flow<String> stream(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ChatMessage systemMessage = new ChatMessage(ChatMessageRole.USER.value(), text);
        this.messages.add(systemMessage);
        ChatCompletionRequest completionRequest = ChatCompletionRequest.builder().model(this.openAiVersion).temperature(Double.valueOf(0.0)).messages(this.messages).build();
        return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super String>, Continuation<? super Unit>, Object>(this, completionRequest, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ OpenAIConnector this$0;
            final /* synthetic */ ChatCompletionRequest $completionRequest;
            {
                this.this$0 = $receiver;
                this.$completionRequest = $completionRequest;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$completionRequest, (ProducerScope<? super String>)$this$callbackFlow, null){
                            int label;
                            final /* synthetic */ OpenAIConnector this$0;
                            final /* synthetic */ ChatCompletionRequest $completionRequest;
                            final /* synthetic */ ProducerScope<String> $$this$callbackFlow;
                            {
                                this.this$0 = $receiver;
                                this.$completionRequest = $completionRequest;
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        OpenAIConnector.access$getService$p(this.this$0).streamChatCompletion(this.$completionRequest).doOnError(arg_0 -> stream.1.invokeSuspend$lambda$0(stream.1.INSTANCE, arg_0)).blockingForEach(arg_0 -> stream.1.invokeSuspend$lambda$1((Function1)new Function1<ChatCompletionChunk, Unit>(this.$$this$callbackFlow){
                                            final /* synthetic */ ProducerScope<String> $$this$callbackFlow;
                                            {
                                                this.$$this$callbackFlow = $$this$callbackFlow;
                                                super(1);
                                            }

                                            public final void invoke(ChatCompletionChunk response) {
                                                ChatMessage completion = ((ChatCompletionChoice)response.getChoices().get(0)).getMessage();
                                                if (completion != null && completion.getContent() != null) {
                                                    String string = completion.getContent();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"completion.content");
                                                    this.$$this$callbackFlow.trySend-JP2dKIU((Object)string);
                                                }
                                            }
                                        }, arg_0));
                                        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$$this$callbackFlow), null, (int)1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0(Function1 $tmp0, Object p0) {
                                $tmp0.invoke(p0);
                            }

                            private static final void invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                                $tmp0.invoke(p0);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @NotNull
    public Duration getTimeout() {
        return LlmConnector.DefaultImpls.getTimeout(this);
    }

    public static final /* synthetic */ OpenAiService access$getService$p(OpenAIConnector $this) {
        return $this.service;
    }
}

