/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.governance;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.comate.connector.LlmConnector;
import org.archguard.spec.base.verifier.LlmRuleVerifier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/archguard/comate/governance/ApiRuleVerifier;", "Lorg/archguard/spec/base/verifier/LlmRuleVerifier;", "connector", "Lorg/archguard/comate/connector/LlmConnector;", "(Lorg/archguard/comate/connector/LlmConnector;)V", "getConnector", "()Lorg/archguard/comate/connector/LlmConnector;", "check", "", "prompt", "", "input", "Companion", "llm-core"})
public final class ApiRuleVerifier
implements LlmRuleVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LlmConnector connector;
    @NotNull
    private static final Logger logger;

    public ApiRuleVerifier(@NotNull LlmConnector connector) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        this.connector = connector;
    }

    @NotNull
    public final LlmConnector getConnector() {
        return this.connector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean check(@NotNull String prompt, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (StringsKt.isBlank((CharSequence)prompt)) return true;
        if (StringsKt.isBlank((CharSequence)input)) {
            return true;
        }
        String finalPrompt = StringsKt.trimMargin$default((String)("\n            | You're a software architect governance expert, please verify the rule with APIs. Here is the requirement:\n            | \n            | 1. If APIs is not need authentication, just return true, no explanation.\n            | 2. If it is not clear whether authentication is needed, just return true, no explanation.\n            | 3. If APIs is need authentication, please check the authentication type, no explanation.\n            | 4. You should only return ###true### or ###false###, no explanation.\n            | 5. Here is your output format, please follow it:\n            | ###\n            | | API  | result |\n            | | ---- | ------ |\n            | | {http action} {uri} | {true or false} |\n            | ###\n            | \n            | Here is rule:\n            | ###\n            |" + prompt + "\n            | ###\n            |\n            | Here is the uri information:\n            | ###\n            | " + input + "\n            | ###\n        "), null, (int)1, null);
        String result = this.connector.prompt(finalPrompt);
        logger.info("start to verify the rule: " + finalPrompt + " result: " + result);
        String string = result.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)string, (Object)"true")) return true;
        String string2 = result.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"true", (boolean)false, (int)2, null)) return false;
        return true;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ApiRuleVerifier.class);
        Intrinsics.checkNotNull((Object)logger);
        ApiRuleVerifier.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/archguard/comate/governance/ApiRuleVerifier$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "llm-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

