/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.token;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.comate.token.TokenCalculate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/archguard/comate/token/LlmTokenCalculate;", "Lorg/archguard/comate/token/TokenCalculate;", "maxToken", "", "modelType", "", "(ILjava/lang/String;)V", "getMaxToken", "()I", "getModelType", "()Ljava/lang/String;", "registry", "Lcom/knuddels/jtokkit/api/EncodingRegistry;", "getRegistry", "()Lcom/knuddels/jtokkit/api/EncodingRegistry;", "setRegistry", "(Lcom/knuddels/jtokkit/api/EncodingRegistry;)V", "calculate", "input", "llm-core"})
public final class LlmTokenCalculate
implements TokenCalculate {
    private final int maxToken;
    @NotNull
    private final String modelType;
    @NotNull
    private EncodingRegistry registry;

    public LlmTokenCalculate(int maxToken, @NotNull String modelType) {
        Intrinsics.checkNotNullParameter((Object)modelType, (String)"modelType");
        this.maxToken = maxToken;
        this.modelType = modelType;
        EncodingRegistry encodingRegistry = Encodings.newDefaultEncodingRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)encodingRegistry, (String)"newDefaultEncodingRegistry()");
        this.registry = encodingRegistry;
    }

    @Override
    public int getMaxToken() {
        return this.maxToken;
    }

    @NotNull
    public final String getModelType() {
        return this.modelType;
    }

    @NotNull
    public final EncodingRegistry getRegistry() {
        return this.registry;
    }

    public final void setRegistry(@NotNull EncodingRegistry encodingRegistry) {
        Intrinsics.checkNotNullParameter((Object)encodingRegistry, (String)"<set-?>");
        this.registry = encodingRegistry;
    }

    @Override
    public int calculate(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Optional modelType = ModelType.fromName((String)this.modelType);
        if (modelType.isPresent()) {
            Encoding encoding = this.registry.getEncodingForModel((ModelType)modelType.get());
            Intrinsics.checkNotNullExpressionValue((Object)encoding, (String)"registry.getEncodingForModel(modelType.get())");
            Encoding enc = encoding;
            return enc.encode(input).size();
        }
        throw new IllegalArgumentException("Model type " + modelType + " not found");
    }

    @Override
    public boolean isOverLimit(@NotNull String input) {
        return TokenCalculate.DefaultImpls.isOverLimit(this, input);
    }
}

