/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.comate.smart;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtSession;
import ai.onnxruntime.OrtUtil;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/archguard/comate/smart/Semantic;", "", "tokenizer", "Lai/djl/huggingface/tokenizers/HuggingFaceTokenizer;", "session", "Lai/onnxruntime/OrtSession;", "env", "Lai/onnxruntime/OrtEnvironment;", "(Lai/djl/huggingface/tokenizers/HuggingFaceTokenizer;Lai/onnxruntime/OrtSession;Lai/onnxruntime/OrtEnvironment;)V", "getEnv", "()Lai/onnxruntime/OrtEnvironment;", "getSession", "()Lai/onnxruntime/OrtSession;", "getTokenizer", "()Lai/djl/huggingface/tokenizers/HuggingFaceTokenizer;", "embed", "", "sequence", "", "Companion", "llm-semantic"})
public final class Semantic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HuggingFaceTokenizer tokenizer;
    @NotNull
    private final OrtSession session;
    @NotNull
    private final OrtEnvironment env;

    public Semantic(@NotNull HuggingFaceTokenizer tokenizer, @NotNull OrtSession session, @NotNull OrtEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.tokenizer = tokenizer;
        this.session = session;
        this.env = env;
    }

    @NotNull
    public final HuggingFaceTokenizer getTokenizer() {
        return this.tokenizer;
    }

    @NotNull
    public final OrtSession getSession() {
        return this.session;
    }

    @NotNull
    public final OrtEnvironment getEnv() {
        return this.env;
    }

    @NotNull
    public final float[] embed(@NotNull String sequence) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        Encoding tokenized = this.tokenizer.encode(sequence, true);
        long[] inputIds = tokenized.getIds();
        long[] attentionMask = tokenized.getAttentionMask();
        long[] typeIds = tokenized.getTypeIds();
        long[] lArray = new long[]{1L, inputIds.length};
        Object tensorInput = OrtUtil.reshape((long[])inputIds, (long[])lArray);
        long[] lArray2 = new long[]{1L, attentionMask.length};
        Object tensorAttentionMask = OrtUtil.reshape((long[])attentionMask, (long[])lArray2);
        long[] lArray3 = new long[]{1L, typeIds.length};
        Object tensorTypeIds = OrtUtil.reshape((long[])typeIds, (long[])lArray3);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"input_ids", (Object)OnnxTensor.createTensor((OrtEnvironment)this.env, (Object)tensorInput)), TuplesKt.to((Object)"attention_mask", (Object)OnnxTensor.createTensor((OrtEnvironment)this.env, (Object)tensorAttentionMask)), TuplesKt.to((Object)"token_type_ids", (Object)OnnxTensor.createTensor((OrtEnvironment)this.env, (Object)tensorTypeIds))};
        OrtSession.Result result = this.session.run(MapsKt.mapOf((Pair[])pairArray));
        OnnxValue onnxValue = result.get(0);
        Intrinsics.checkNotNull((Object)onnxValue, (String)"null cannot be cast to non-null type ai.onnxruntime.OnnxTensor");
        OnnxTensor outputTensor = (OnnxTensor)onnxValue;
        float[] output = outputTensor.getFloatBuffer().array();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        return output;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/archguard/comate/smart/Semantic$Companion;", "", "()V", "create", "Lorg/archguard/comate/smart/Semantic;", "llm-semantic"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Semantic create() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL uRL = classLoader.getResource("model/tokenizer.json");
            Intrinsics.checkNotNull((Object)uRL);
            URI tokenizerPath = uRL.toURI();
            URL uRL2 = classLoader.getResource("model/model.onnx");
            Intrinsics.checkNotNull((Object)uRL2);
            URI onnxPath = uRL2.toURI();
            try {
                Map env = new HashMap();
                String string = tokenizerPath.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokenizerPath.toString()");
                String[] stringArray = new String[]{"!"};
                List array = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                FileSystems.newFileSystem(URI.create((String)array.get(0)), env);
            }
            catch (Exception env) {
                // empty catch block
            }
            HuggingFaceTokenizer tokenizer = HuggingFaceTokenizer.newInstance((Path)Paths.get(tokenizerPath));
            OrtEnvironment ortEnv = OrtEnvironment.getEnvironment();
            OrtSession.SessionOptions sessionOptions = new OrtSession.SessionOptions();
            byte[] onnxPathAsByteArray = Files.readAllBytes(Paths.get(onnxPath));
            OrtSession session = ortEnv.createSession(onnxPathAsByteArray, sessionOptions);
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"tokenizer");
            Intrinsics.checkNotNullExpressionValue((Object)session, (String)"session");
            Intrinsics.checkNotNullExpressionValue((Object)ortEnv, (String)"ortEnv");
            return new Semantic(tokenizer, session, ortEnv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

