/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.spec.lang.foundation.rule;

import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.archguard.architecture.style.NamingStyle;
import org.archguard.spec.base.Rule;
import org.archguard.spec.base.RuleResult;
import org.archguard.spec.element.FoundationElement;
import org.archguard.spec.lang.foundation.declaration.NamingTarget;
import org.archguard.spec.lang.foundation.rule.NamingRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J-\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00072\u001d\u0010\u0018\u001a\u0019\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019j\u0002`\u001b\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0007J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/archguard/spec/lang/foundation/rule/NamingStyleRule;", "Lorg/archguard/spec/base/Rule;", "Lorg/archguard/spec/element/FoundationElement;", "target", "Lorg/archguard/spec/lang/foundation/declaration/NamingTarget;", "(Lorg/archguard/spec/lang/foundation/declaration/NamingTarget;)V", "actionName", "", "getActionName", "()Ljava/lang/String;", "filterPattern", "Lkotlin/text/Regex;", "namingRule", "Lorg/archguard/spec/lang/foundation/rule/NamingRule;", "namingStyle", "Lorg/archguard/architecture/style/NamingStyle;", "getTarget", "()Lorg/archguard/spec/lang/foundation/declaration/NamingTarget;", "exec", "", "Lorg/archguard/spec/base/RuleResult;", "input", "pattern", "", "block", "Lkotlin/Function1;", "Ljava/io/Serializable;", "Lorg/archguard/spec/lang/foundation/expression/NamingExpression;", "Lkotlin/ExtensionFunctionType;", "style", "toString", "verifyNodeName", "spec-lang"})
@SourceDebugExtension(value={"SMAP\nNamingStyleRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingStyleRule.kt\norg/archguard/spec/lang/foundation/rule/NamingStyleRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n766#2:96\n857#2,2:97\n1549#2:99\n1620#2,3:100\n1855#2,2:103\n1549#2:105\n1620#2,2:106\n1549#2:108\n1620#2,3:109\n1622#2:112\n*S KotlinDebug\n*F\n+ 1 NamingStyleRule.kt\norg/archguard/spec/lang/foundation/rule/NamingStyleRule\n*L\n42#1:96\n42#1:97,2\n45#1:99\n45#1:100,3\n48#1:103,2\n57#1:105\n57#1:106,2\n70#1:108\n70#1:109,3\n57#1:112\n*E\n"})
public final class NamingStyleRule
implements Rule<FoundationElement> {
    @NotNull
    private final NamingTarget target;
    @NotNull
    private Regex filterPattern;
    @Nullable
    private NamingRule namingRule;
    @NotNull
    private NamingStyle namingStyle;

    public NamingStyleRule(@NotNull NamingTarget target) {
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        this.target = target;
        this.filterPattern = new Regex(".*");
        this.namingStyle = NamingStyle.CamelCase;
    }

    @NotNull
    public final NamingTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public String getActionName() {
        return "Naming for " + this.target.name();
    }

    public final void style(@NotNull String style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        if (!NamingStyle.Companion.contains(style)) {
            throw new IllegalArgumentException("Unknown naming style: " + style + ". Supported styles: " + NamingStyle.Companion.valuesString());
        }
        this.namingStyle = NamingStyle.valueOf((String)style);
    }

    public final void pattern(@NotNull String pattern, @NotNull Function1<? super NamingRule, ? extends Serializable> block) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.filterPattern = new Regex(pattern);
        NamingRule namingRule = new NamingRule();
        namingRule.delayBlock(block);
        this.namingRule = namingRule;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RuleResult> exec(@NotNull FoundationElement input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List results = new ArrayList();
        CollectionsKt.addAll((Collection)results, (Iterable)this.verifyNodeName(input));
        if (this.namingRule != null) {
            void $this$mapTo$iv$iv;
            CodeDataStruct it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = input.getDs();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CodeDataStruct)element$iv$iv;
                boolean bl = false;
                if (!this.filterPattern.matches((CharSequence)it.getNodeName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (CodeDataStruct)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                NamingRule namingRule = this.namingRule;
                Intrinsics.checkNotNull((Object)namingRule);
                collection.add(namingRule.exec(it.getNodeName()));
            }
            Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RuleResult it2 = (RuleResult)element$iv;
                boolean bl = false;
                results.add(it2);
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RuleResult> verifyNodeName(FoundationElement input) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = input.getDs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list;
            CodeDataStruct codeDataStruct = (CodeDataStruct)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String rule = "Level: " + this.target + ", NamingStyle: " + this.namingStyle;
            switch (WhenMappings.$EnumSwitchMapping$0[this.target.ordinal()]) {
                case 1: {
                    void it;
                    list = CollectionsKt.listOf((Object)new RuleResult(this.getActionName(), rule, this.namingStyle.isValid(it.getPackage()), it.getPackage()));
                    break;
                }
                case 2: {
                    void it;
                    list = CollectionsKt.listOf((Object)new RuleResult(this.getActionName(), rule, this.namingStyle.isValid(it.getNodeName()), it.getNodeName()));
                    break;
                }
                case 3: {
                    void $this$mapTo$iv$iv2;
                    void it;
                    Iterable $this$map$iv2 = it.getFunctions();
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it2;
                        CodeFunction codeFunction = (CodeFunction)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(new RuleResult(this.getActionName(), rule, this.namingStyle.isValid(it2.getName()), it2.getName()));
                    }
                    list = (List)destination$iv$iv2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public String toString() {
        String string = this.target.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.trimIndent((String)("\n                " + string + "_level {\n                    style(\"" + this.namingStyle.name() + "\")\n                    pattern(\"" + this.filterPattern.getPattern() + "\") { " + this.namingRule + " }\n                }\n            "));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NamingTarget.values().length];
            try {
                nArray[NamingTarget.Package.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamingTarget.Class.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NamingTarget.Function.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

