/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.spec.lang.foundation.rule;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.archguard.spec.base.Rule;
import org.archguard.spec.base.RuleResult;
import org.archguard.spec.element.FoundationElement;
import org.archguard.spec.lang.base.BaseDeclaration;
import org.archguard.spec.lang.base.PatternWithExampleRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/archguard/spec/lang/foundation/rule/ProjectNameRule;", "Lorg/archguard/spec/lang/base/PatternWithExampleRule;", "Lorg/archguard/spec/element/FoundationElement;", "Lorg/archguard/spec/lang/base/BaseDeclaration;", "()V", "actionName", "", "getActionName", "()Ljava/lang/String;", "originRegex", "ruleRegex", "Lkotlin/text/Regex;", "sample", "example", "", "exec", "", "Lorg/archguard/spec/base/RuleResult;", "input", "pattern", "regex", "rules", "Lorg/archguard/spec/base/Rule;", "element", "toString", "spec-lang"})
public final class ProjectNameRule
implements PatternWithExampleRule<FoundationElement>,
BaseDeclaration<FoundationElement> {
    @NotNull
    private final String actionName;
    @NotNull
    private String originRegex = "";
    @Nullable
    private Regex ruleRegex;
    @NotNull
    private String sample = "";

    public ProjectNameRule() {
        this.actionName = "ProjectName";
    }

    @Override
    @NotNull
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public void pattern(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.originRegex = regex;
        try {
            this.ruleRegex = new Regex(regex);
        }
        catch (Exception e) {
            throw new Exception("Invalid regex: " + regex);
        }
    }

    @Override
    public void example(@NotNull String sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this.sample = sample;
    }

    @Override
    @NotNull
    public List<RuleResult> exec(@NotNull FoundationElement input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String ruleExplain = "regex: " + this.originRegex + "sample: " + this.sample;
        if (this.ruleRegex != null) {
            Regex regex = this.ruleRegex;
            Intrinsics.checkNotNull((Object)regex);
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)input.getProjectName(), (int)0, (int)2, null);
            return CollectionsKt.listOf((Object)new RuleResult(this.getActionName(), ruleExplain, matchResult != null, input.getProjectName()));
        }
        return CollectionsKt.listOf((Object)new RuleResult(this.getActionName(), ruleExplain, false, input.getProjectName()));
    }

    @Override
    @NotNull
    public List<Rule<FoundationElement>> rules(@NotNull FoundationElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n        project_name {\n            pattern(\"" + this.originRegex + "\")\n            example(\"" + this.sample + "\")\n        }\n        "));
    }
}

