/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.spec.lang.restapi.rule;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.archguard.spec.base.RuleResult;
import org.archguard.spec.element.RestApiElement;
import org.archguard.spec.lang.base.PatternWithExampleRule;
import org.archguard.spec.lang.restapi.ApiAtomicRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/archguard/spec/lang/restapi/rule/UriConstructionRule;", "Lorg/archguard/spec/lang/restapi/ApiAtomicRule;", "Lorg/archguard/spec/lang/base/PatternWithExampleRule;", "Lorg/archguard/spec/element/RestApiElement;", "()V", "ruleRegex", "Lkotlin/text/Regex;", "sample", "", "example", "", "exec", "", "Lorg/archguard/spec/base/RuleResult;", "input", "pattern", "regex", "spec-lang"})
public final class UriConstructionRule
extends ApiAtomicRule
implements PatternWithExampleRule<RestApiElement> {
    @Nullable
    private Regex ruleRegex;
    @NotNull
    private String sample = "";

    public UriConstructionRule() {
        super("uri-construction", "uri construction regex: //TODO");
    }

    @Override
    public void pattern(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.ruleRegex = new Regex(regex);
        this.setRule("uri construction regex: " + regex);
    }

    @Override
    public void example(@NotNull String sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this.sample = sample;
    }

    @Override
    @NotNull
    public List<RuleResult> exec(@NotNull RestApiElement input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.ruleRegex != null) {
            Regex regex = this.ruleRegex;
            Intrinsics.checkNotNull((Object)regex);
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)input.getUri(), (int)0, (int)2, null);
            return CollectionsKt.listOf((Object)new RuleResult(this.getActionName(), this.sample, matchResult != null, null, 8, null));
        }
        return CollectionsKt.listOf((Object)new RuleResult(this.getActionName(), this.sample, false, null, 8, null));
    }
}

