/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.spec.runtime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.spec.runtime.compiler.KotlinReplWrapper;
import org.archguard.spec.runtime.interpreter.api.InterpreterRequest;
import org.archguard.spec.runtime.messaging.ErrorContent;
import org.archguard.spec.runtime.messaging.Message;
import org.archguard.spec.runtime.messaging.MessageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.repl.EvalResultEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/archguard/spec/runtime/KotlinInterpreter;", "", "()V", "compiler", "Lorg/archguard/spec/runtime/compiler/KotlinReplWrapper;", "logger", "Lorg/slf4j/Logger;", "convertResult", "Lorg/archguard/spec/runtime/messaging/Message;", "result", "Lorg/jetbrains/kotlinx/jupyter/repl/EvalResultEx;", "id", "", "eval", "request", "Lorg/archguard/spec/runtime/interpreter/api/InterpreterRequest;", "evalCast", "T", "(Lorg/archguard/spec/runtime/interpreter/api/InterpreterRequest;)Ljava/lang/Object;", "spec-runtime"})
public final class KotlinInterpreter {
    @NotNull
    private KotlinReplWrapper compiler = new KotlinReplWrapper();
    @NotNull
    private final Logger logger;

    public KotlinInterpreter() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this.javaClass)");
        this.logger = logger;
    }

    @NotNull
    public final Message eval(@NotNull InterpreterRequest request) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            EvalResultEx resultEx = this.compiler.eval(request.getCode(), request.getId(), request.getHistory());
            message = this.convertResult(resultEx, request.getId());
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            String string = e.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.javaClass.name");
            ErrorContent content = new ErrorContent(string, e.toString());
            message = new Message(request.getId(), "", "", "", MessageType.ERROR, content);
        }
        return message;
    }

    @Nullable
    public final <T> T evalCast(@NotNull InterpreterRequest request) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            EvalResultEx resultEx = this.compiler.eval(request.getCode(), request.getId(), request.getHistory());
            object = resultEx.getRawValue();
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            return null;
        }
        return (T)object;
    }

    private final Message convertResult(EvalResultEx result, int id) {
        String string;
        Class<?> resultValue = result.getRawValue();
        Class<?> clazz = resultValue;
        if ((clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : (string = null)) == null) {
            string = "";
        }
        String className = string;
        String string2 = String.valueOf(resultValue);
        String string3 = String.valueOf(result.getRawValue());
        return new Message(id, string2, string3, className, null, null, 48, null);
    }
}

