/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.integration.axon;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.archifacts.core.descriptor.SourceBasedArtifactRelationshipDescriptor;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactRelationshipRole;

abstract class AbstractIdentifiedByDescriptor
implements SourceBasedArtifactRelationshipDescriptor {
    private static final ArtifactRelationshipRole ROLE = ArtifactRelationshipRole.of((String)"identified by");

    AbstractIdentifiedByDescriptor() {
    }

    public ArtifactRelationshipRole role() {
        return ROLE;
    }

    public boolean isSource(Artifact sourceCandidateArtifact) {
        return this.getIdentifierFieldOrMethod(sourceCandidateArtifact.getJavaClass()).findAny().isPresent();
    }

    private Stream<JavaMember> getIdentifierFieldOrMethod(JavaClass sourceClass) {
        return sourceClass.getMembers().stream().filter(f -> f.isMetaAnnotatedWith(this.getAnnotationClass()));
    }

    public Stream<JavaClass> targets(JavaClass sourceClass) {
        return this.getIdentifierFieldOrMethod(sourceClass).map(m -> this.getType((JavaMember)m));
    }

    private JavaClass getType(JavaMember javaMember) {
        if (javaMember instanceof JavaField) {
            return ((JavaField)javaMember).getRawType();
        }
        if (javaMember instanceof JavaMethod) {
            return ((JavaMethod)javaMember).getRawReturnType();
        }
        throw new IllegalArgumentException(String.format("A JavaMember (%s) annotated with '%s' is neither a field nor a method.", javaMember, this.getAnnotationClass().getSimpleName()));
    }

    protected abstract Class<? extends Annotation> getAnnotationClass();
}

