/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.integration.axon;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.archifacts.core.descriptor.SourceBasedArtifactRelationshipDescriptor;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactRelationshipRole;
import org.axonframework.modelling.command.AggregateMember;

final class AggregateMemberDescriptor
implements SourceBasedArtifactRelationshipDescriptor {
    private static final ArtifactRelationshipRole ROLE = ArtifactRelationshipRole.of((String)"has aggregate member");

    AggregateMemberDescriptor() {
    }

    public ArtifactRelationshipRole role() {
        return ROLE;
    }

    public boolean isSource(Artifact sourceCandidateArtifact) {
        return this.getAggregateMembersOrFields(sourceCandidateArtifact.getJavaClass()).anyMatch(x -> true);
    }

    private Stream<JavaMember> getAggregateMembersOrFields(JavaClass sourceClass) {
        return sourceClass.getMembers().stream().filter(m -> m.isMetaAnnotatedWith(AggregateMember.class) && this.isNotUntypedCollectionOrMap(this.getType((JavaMember)m)));
    }

    public Stream<JavaClass> targets(JavaClass sourceClass) {
        return this.getAggregateMembersOrFields(sourceClass).map(m -> this.getType((JavaMember)m)).map(t -> this.getJavaClass((JavaType)t));
    }

    private JavaType getType(JavaMember javaMember) {
        if (javaMember instanceof JavaField) {
            return ((JavaField)javaMember).getType();
        }
        if (javaMember instanceof JavaMethod) {
            return ((JavaMethod)javaMember).getReturnType();
        }
        throw new IllegalArgumentException(String.format("A JavaMember (%s) annotated with '%s' is neither a field nor a method.", javaMember, AggregateMember.class.getSimpleName()));
    }

    private JavaClass getJavaClass(JavaType type) {
        JavaClass erasure = type.toErasure();
        if (type instanceof JavaParameterizedType && erasure.isAssignableTo(Collection.class)) {
            JavaType collectionType = (JavaType)((JavaParameterizedType)type).getActualTypeArguments().get(0);
            return collectionType.toErasure();
        }
        if (type instanceof JavaParameterizedType && erasure.isAssignableTo(Map.class)) {
            JavaType valueType = (JavaType)((JavaParameterizedType)type).getActualTypeArguments().get(1);
            return valueType.toErasure();
        }
        return erasure;
    }

    private boolean isNotUntypedCollectionOrMap(JavaType type) {
        boolean isUntypedCollection = type.toErasure().isAssignableTo(Collection.class) && !(type instanceof JavaParameterizedType);
        boolean isUntypedMap = type.toErasure().isAssignableTo(Map.class) && !(type instanceof JavaParameterizedType);
        return !isUntypedCollection && !isUntypedMap;
    }
}

