/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.archifacts.core.model.ArtifactContainer;
import org.archifacts.core.model.ArtifactRelationship;
import org.archifacts.core.model.Named;

public abstract class Artifact
implements Named {
    private final JavaClass javaClass;
    private Optional<ArtifactContainer> container = Optional.empty();
    private final Set<ArtifactRelationship> outgoingRelationships = new LinkedHashSet<ArtifactRelationship>();
    private final Set<ArtifactRelationship> incomingRelationships = new LinkedHashSet<ArtifactRelationship>();

    Artifact(JavaClass javaClass) {
        this.javaClass = javaClass;
    }

    public Optional<ArtifactContainer> getContainer() {
        return this.container;
    }

    void setContainer(ArtifactContainer container) {
        if (this.container.isPresent()) {
            throw new IllegalStateException(String.format("The container of the artifact %s has already been set.", this));
        }
        this.container = Optional.of(container);
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    void addOutgoingRelationship(ArtifactRelationship relationship) {
        if (relationship.getSource() != this) {
            throw new IllegalStateException(String.format("The source of the given relationship does not match this artifact. Actual: %s, Expected: %s", relationship.getSource(), this));
        }
        this.outgoingRelationships.add(relationship);
    }

    void addIncomingRelationship(ArtifactRelationship relationship) {
        if (relationship.getTarget() != this) {
            throw new IllegalStateException(String.format("The target of the given relationship does not match this artifact. Actual: %s, Expected: %s", relationship.getTarget(), this));
        }
        this.incomingRelationships.add(relationship);
    }

    @Override
    public String getName() {
        String name = this.javaClass.getSimpleName();
        if (name.isEmpty()) {
            String fullyQualifiedName = this.javaClass.getFullName();
            int indexOfLastDot = fullyQualifiedName.lastIndexOf(46);
            name = indexOfLastDot > -1 ? fullyQualifiedName.substring(indexOfLastDot + 1) : fullyQualifiedName;
        }
        return name;
    }

    public Set<ArtifactRelationship> getIncomingRelationships() {
        return Collections.unmodifiableSet(this.incomingRelationships);
    }

    public Set<ArtifactRelationship> getOutgoingRelationships() {
        return Collections.unmodifiableSet(this.outgoingRelationships);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        return Objects.equals(this.javaClass.getName(), other.javaClass.getName());
    }
}

