/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.archifacts.core.model.Application;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactContainerDescription;
import org.archifacts.core.model.ArtifactContainerType;
import org.archifacts.core.model.HasArtifacts;
import org.archifacts.core.model.Named;

public final class ArtifactContainer
implements HasArtifacts,
Named {
    private final ArtifactContainerDescription description;
    private Application application;
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();

    ArtifactContainer(ArtifactContainerDescription description) {
        this.description = description;
    }

    void setApplication(Application application) {
        this.application = application;
    }

    void addArtifact(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    public Application getApplication() {
        return this.application;
    }

    @Override
    public Set<Artifact> getArtifacts() {
        return Collections.unmodifiableSet(this.artifacts);
    }

    @Override
    public String getName() {
        return this.description.getName();
    }

    public ArtifactContainerType getType() {
        return this.description.getType();
    }

    public String toString() {
        return "<" + this.description.getType().getName() + "> " + this.description.getName();
    }

    public int hashCode() {
        return Objects.hash(this.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactContainer other = (ArtifactContainer)obj;
        return Objects.equals(this.description, other.description);
    }
}

