/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import java.util.Objects;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactRelationshipRole;

public final class ArtifactRelationship {
    private final Artifact source;
    private final Artifact target;
    private final ArtifactRelationshipRole role;

    ArtifactRelationship(Artifact source, Artifact target, ArtifactRelationshipRole role) {
        this.source = source;
        this.target = target;
        this.role = role;
    }

    public Artifact getSource() {
        return this.source;
    }

    public Artifact getTarget() {
        return this.target;
    }

    public ArtifactRelationshipRole getRole() {
        return this.role;
    }

    public String toString() {
        return this.source + " " + this.role + " " + this.target;
    }

    public int hashCode() {
        return Objects.hash(this.role, this.source, this.target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactRelationship other = (ArtifactRelationship)obj;
        return Objects.equals(this.role, other.role) && Objects.equals(this.source, other.source) && Objects.equals(this.target, other.target);
    }
}

