/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.BuildingBlock;
import org.archifacts.core.model.BuildingBlockType;
import org.archifacts.core.model.ExternalArtifact;
import org.archifacts.core.model.MiscArtifact;

public interface HasArtifacts {
    public Set<Artifact> getArtifacts();

    default public Set<BuildingBlock> getArtifactsOfType(BuildingBlockType buildingBlockType) {
        return this.getArtifactsOfType(BuildingBlock.class).stream().filter(buildingBlock -> buildingBlock.getType().equals(buildingBlockType)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    default public Set<BuildingBlock> getBuildingBlocks() {
        return this.getArtifactsOfType(BuildingBlock.class);
    }

    default public Set<MiscArtifact> getMiscArtifacts() {
        return this.getArtifactsOfType(MiscArtifact.class);
    }

    default public Set<ExternalArtifact> getExternalArtifacts() {
        return this.getArtifactsOfType(ExternalArtifact.class);
    }

    private <T extends Artifact> Set<T> getArtifactsOfType(Class<T> type) {
        return this.getArtifacts().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

