/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.descriptor;

import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Objects;
import java.util.stream.Stream;
import org.archifacts.core.descriptor.BuildingBlockDescriptor;
import org.archifacts.core.model.BuildingBlockType;

final class BuildingBlockDescriptorForAssignableTo
implements BuildingBlockDescriptor {
    private final BuildingBlockType buildingBlockType;
    private final Class<?>[] types;

    BuildingBlockDescriptorForAssignableTo(BuildingBlockType buildingBlockType, Class<?> ... types) {
        this.buildingBlockType = Objects.requireNonNull(buildingBlockType, "The building block type must not be null.");
        this.types = Objects.requireNonNull(types, "The types must not be null.");
    }

    @Override
    public BuildingBlockType type() {
        return this.buildingBlockType;
    }

    @Override
    public boolean isBuildingBlock(JavaClass javaClass) {
        return Stream.of(this.types).anyMatch(arg_0 -> ((JavaClass)javaClass).isAssignableTo(arg_0));
    }
}

