/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import java.util.Objects;
import org.archifacts.core.model.ArtifactContainer;
import org.archifacts.core.model.ArtifactContainerType;

final class ArtifactContainerDescription {
    private final ArtifactContainerType type;
    private final String name;

    ArtifactContainerDescription(ArtifactContainerType type, String name) {
        this.type = type;
        this.name = name;
    }

    ArtifactContainerType getType() {
        return this.type;
    }

    String getName() {
        return this.name;
    }

    static ArtifactContainerDescription fromContainer(ArtifactContainer container) {
        return new ArtifactContainerDescription(container.getType(), container.getName());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactContainerDescription other = (ArtifactContainerDescription)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }
}

