/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.archifacts.core.model.ApplicationBuilder;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactContainer;
import org.archifacts.core.model.ArtifactContainerDescription;
import org.archifacts.core.model.ArtifactRelationship;
import org.archifacts.core.model.HasArtifacts;
import org.archifacts.core.model.HasContainers;
import org.archifacts.core.model.HasRelationships;

public final class Application
implements HasContainers,
HasArtifacts,
HasRelationships {
    private static final Logger LOG = LogManager.getLogger(Application.class);
    private final Map<ArtifactContainerDescription, ArtifactContainer> containers = new LinkedHashMap<ArtifactContainerDescription, ArtifactContainer>();
    private final Map<JavaClass, Artifact> artifacts = new LinkedHashMap<JavaClass, Artifact>();
    private final Set<ArtifactRelationship> relationships = new LinkedHashSet<ArtifactRelationship>();

    public static ApplicationBuilder builder() {
        return new ApplicationBuilder();
    }

    Application() {
    }

    @Override
    public Set<Artifact> getArtifacts() {
        return Set.copyOf(this.artifacts.values());
    }

    @Override
    public Set<ArtifactContainer> getContainers() {
        return Set.copyOf(this.containers.values());
    }

    @Override
    public Set<ArtifactRelationship> getRelationships() {
        return Collections.unmodifiableSet(this.relationships);
    }

    void addContainer(ArtifactContainer container) {
        LOG.debug(() -> "Adding container: " + container);
        this.containers.put(ArtifactContainerDescription.fromContainer(container), container);
        container.setApplication(this);
    }

    void addArtifact(ArtifactContainerDescription containerDescription, Artifact artifact) {
        ArtifactContainer container;
        if (!this.containers.containsKey(containerDescription)) {
            container = new ArtifactContainer(containerDescription);
            this.addContainer(container);
        } else {
            container = this.containers.get(containerDescription);
        }
        container.addArtifact(artifact);
        artifact.setContainer(container);
        this.addArtifact(artifact);
    }

    void addArtifact(Artifact artifact) {
        LOG.debug(() -> "Adding artifact: " + artifact);
        this.artifacts.put(artifact.getJavaClass(), artifact);
    }

    void addRelationship(ArtifactRelationship relationship) {
        LOG.debug(() -> "Adding relationship: " + relationship);
        Artifact source = relationship.getSource();
        Artifact target = relationship.getTarget();
        if (!this.artifacts.containsKey(source.getJavaClass())) {
            throw new IllegalStateException(String.format("The artifact %s has not been added.", source));
        }
        if (!this.artifacts.containsKey(target.getJavaClass())) {
            throw new IllegalStateException(String.format("The artifact %s has not been added.", target));
        }
        this.relationships.add(relationship);
        source.addOutgoingRelationship(relationship);
        target.addIncomingRelationship(relationship);
    }

    Artifact getArtifactForClass(JavaClass javaClass) {
        return this.artifacts.get(javaClass);
    }
}

