/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.archifacts.core.descriptor.ArtifactContainerDescriptor;
import org.archifacts.core.descriptor.BuildingBlockDescriptor;
import org.archifacts.core.descriptor.Descriptor;
import org.archifacts.core.descriptor.SourceBasedArtifactRelationshipDescriptor;
import org.archifacts.core.descriptor.TargetBasedArtifactRelationshipDescriptor;
import org.archifacts.core.model.Application;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactContainerDescription;
import org.archifacts.core.model.ArtifactRelationship;
import org.archifacts.core.model.BuildingBlock;
import org.archifacts.core.model.ExternalArtifact;
import org.archifacts.core.model.MiscArtifact;

public final class ApplicationBuilder {
    private final List<ArtifactContainerDescriptor> containerDescriptors = new ArrayList<ArtifactContainerDescriptor>();
    private final List<BuildingBlockDescriptor> buildingBlockDescriptors = new ArrayList<BuildingBlockDescriptor>();
    private final Set<SourceBasedArtifactRelationshipDescriptor> sourceBasedRelationshipDescriptors = new LinkedHashSet<SourceBasedArtifactRelationshipDescriptor>();
    private final Set<TargetBasedArtifactRelationshipDescriptor> targetBasedRelationshipDescriptors = new LinkedHashSet<TargetBasedArtifactRelationshipDescriptor>();

    ApplicationBuilder() {
    }

    public ApplicationBuilder descriptor(Descriptor descriptor) {
        Objects.requireNonNull(descriptor, "The Descriptor cannot be null");
        if (descriptor instanceof ArtifactContainerDescriptor) {
            this.containerDescriptors.add((ArtifactContainerDescriptor)descriptor);
        } else if (descriptor instanceof BuildingBlockDescriptor) {
            this.buildingBlockDescriptors.add((BuildingBlockDescriptor)descriptor);
        } else if (descriptor instanceof SourceBasedArtifactRelationshipDescriptor) {
            this.sourceBasedRelationshipDescriptors.add((SourceBasedArtifactRelationshipDescriptor)descriptor);
        } else if (descriptor instanceof TargetBasedArtifactRelationshipDescriptor) {
            this.targetBasedRelationshipDescriptors.add((TargetBasedArtifactRelationshipDescriptor)descriptor);
        } else {
            throw new IllegalArgumentException("The descriptor has an unexpected type: " + descriptor.getClass().getName());
        }
        return this;
    }

    public Application buildApplication(JavaClasses javaClasses) {
        Objects.requireNonNull(javaClasses, "JavaClasses cannot be null");
        Application application = new Application();
        this.toArtifacts(javaClasses).forEach(artifact -> this.addArtifact(application, (Artifact)artifact));
        this.targetBasedRelationshipDescriptors.stream().forEach(targetBasedRelationshipDescriptor -> application.getArtifacts().stream().forEach(artifact -> {
            if (targetBasedRelationshipDescriptor.isTarget((Artifact)artifact)) {
                targetBasedRelationshipDescriptor.sources(artifact.getJavaClass()).forEach(sourceJavaClass -> {
                    Artifact sourceArtifact = application.getArtifactForClass((JavaClass)sourceJavaClass);
                    if (sourceArtifact == null) {
                        sourceArtifact = new ExternalArtifact((JavaClass)sourceJavaClass);
                        this.addArtifact(application, sourceArtifact);
                    }
                    application.addRelationship(new ArtifactRelationship(sourceArtifact, (Artifact)artifact, targetBasedRelationshipDescriptor.role()));
                });
            }
        }));
        this.sourceBasedRelationshipDescriptors.stream().forEach(sourceBasedRelationshipDescriptor -> application.getArtifacts().stream().forEach(artifact -> {
            if (sourceBasedRelationshipDescriptor.isSource((Artifact)artifact)) {
                sourceBasedRelationshipDescriptor.targets(artifact.getJavaClass()).forEach(targetJavaClass -> {
                    Artifact targetArtifact = application.getArtifactForClass((JavaClass)targetJavaClass);
                    if (targetArtifact == null) {
                        targetArtifact = new ExternalArtifact((JavaClass)targetJavaClass);
                        this.addArtifact(application, targetArtifact);
                    }
                    application.addRelationship(new ArtifactRelationship((Artifact)artifact, targetArtifact, sourceBasedRelationshipDescriptor.role()));
                });
            }
        }));
        return application;
    }

    private void addArtifact(Application application, Artifact artifact) {
        this.containerDescriptors.stream().map(containerDescriptor -> containerDescriptor.containerNameOf(artifact.getJavaClass()).map(containerName -> new ArtifactContainerDescription(containerDescriptor.type(), (String)containerName))).filter(Optional::isPresent).map(Optional::get).distinct().findFirst().ifPresentOrElse(archContainerDescription -> application.addArtifact((ArtifactContainerDescription)archContainerDescription, artifact), () -> application.addArtifact(artifact));
    }

    private Stream<Artifact> toArtifacts(JavaClasses javaClasses) {
        return javaClasses.stream().map(javaClass -> this.toArtifact((JavaClass)javaClass));
    }

    private Artifact toArtifact(JavaClass javaClass) {
        return this.buildingBlockDescriptors.stream().filter(buildingBlockDescriptor -> buildingBlockDescriptor.isBuildingBlock(javaClass)).findFirst().map(buildingBlockDescriptor -> this.toBuildingBlock(javaClass, (BuildingBlockDescriptor)buildingBlockDescriptor)).orElseGet(() -> this.toMiscArtifact(javaClass));
    }

    private Artifact toBuildingBlock(JavaClass javaClass, BuildingBlockDescriptor buildingBlockDescriptor) {
        return new BuildingBlock(javaClass, buildingBlockDescriptor.type());
    }

    private Artifact toMiscArtifact(JavaClass javaClass) {
        return new MiscArtifact(javaClass);
    }
}

