/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.archifacts.core.model.ArchifactsCollectors;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.BuildingBlock;
import org.archifacts.core.model.BuildingBlockType;
import org.archifacts.core.model.ExternalArtifact;
import org.archifacts.core.model.MiscArtifact;

public interface HasArtifacts {
    public Set<Artifact> getArtifacts();

    default public Set<BuildingBlock> getBuildingBlocksOfType(BuildingBlockType buildingBlockType) {
        return this.getBuildingBlocksOfTypes(buildingBlockType);
    }

    default public Set<BuildingBlock> getBuildingBlocksOfTypes(BuildingBlockType ... buildingBlockTypes) {
        List<BuildingBlockType> buildigBlockTypeList = Arrays.asList(buildingBlockTypes);
        return this.getArtifactsOfType(BuildingBlock.class).stream().filter(buildingBlock -> buildigBlockTypeList.contains(buildingBlock.getType())).collect(ArchifactsCollectors.toUnmodifiableLinkedSet());
    }

    default public Set<BuildingBlock> getBuildingBlocks() {
        return this.getArtifactsOfType(BuildingBlock.class);
    }

    default public Set<MiscArtifact> getMiscArtifacts() {
        return this.getArtifactsOfType(MiscArtifact.class);
    }

    default public Set<ExternalArtifact> getExternalArtifacts() {
        return this.getArtifactsOfType(ExternalArtifact.class);
    }

    private <T extends Artifact> Set<T> getArtifactsOfType(Class<T> type) {
        return this.getArtifacts().stream().filter(type::isInstance).map(type::cast).collect(ArchifactsCollectors.toUnmodifiableLinkedSet());
    }
}

