/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.core.model;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.archifacts.core.model.ArchifactsCollectors;
import org.archifacts.core.model.ArtifactRelationship;
import org.archifacts.core.model.ArtifactRelationshipRole;

public interface HasIncomingRelationships {
    public Set<ArtifactRelationship> getIncomingRelationships();

    default public Set<ArtifactRelationship> getIncomingRelationshipsOfRole(ArtifactRelationshipRole role) {
        return this.getIncomingRelationshipsOfRoles(role);
    }

    default public Set<ArtifactRelationship> getIncomingRelationshipsOfRoles(ArtifactRelationshipRole ... roles) {
        List<ArtifactRelationshipRole> roleList = Arrays.asList(roles);
        return this.getIncomingRelationships().stream().filter(r -> roleList.contains(r.getRole())).collect(ArchifactsCollectors.toUnmodifiableLinkedSet());
    }
}

