/*
 * Decompiled with CFR 0.152.
 */
package org.archifacts.integration.jmolecules;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.archifacts.core.descriptor.SourceBasedArtifactRelationshipDescriptor;
import org.archifacts.core.model.Artifact;
import org.archifacts.core.model.ArtifactRelationshipRole;
import org.archifacts.core.model.BuildingBlock;
import org.archifacts.core.model.BuildingBlockType;
import org.archifacts.integration.jmolecules.JMoleculesDescriptors;

final class ContainedEntityDescriptor
implements SourceBasedArtifactRelationshipDescriptor {
    private static final ArtifactRelationshipRole ROLE = ArtifactRelationshipRole.of((String)"contains");

    ContainedEntityDescriptor() {
    }

    public ArtifactRelationshipRole role() {
        return ROLE;
    }

    public boolean isSource(Artifact sourceCandidateArtifact) {
        if (!(sourceCandidateArtifact instanceof BuildingBlock)) {
            return false;
        }
        BuildingBlock buildingBlock = (BuildingBlock)sourceCandidateArtifact;
        BuildingBlockType buildingBlockType = buildingBlock.getType();
        return buildingBlockType.equals((Object)JMoleculesDescriptors.BuildingBlockDescriptors.AggregateRootDescriptor.type()) || buildingBlockType.equals((Object)JMoleculesDescriptors.BuildingBlockDescriptors.EntityDescriptor.type());
    }

    public Stream<JavaClass> targets(JavaClass sourceClass) {
        return sourceClass.getFields().stream().map(this::referencedEntity).filter(Optional::isPresent).map(Optional::get);
    }

    private boolean isCollection(JavaField field) {
        return field.getRawType().isAssignableTo(Collection.class);
    }

    private boolean isMap(JavaField field) {
        return field.getRawType().isAssignableTo(Map.class);
    }

    private Optional<JavaClass> referencedEntity(JavaField field) {
        JavaClass javaClass;
        List actualTypeArguments;
        JavaType fieldType;
        if (JMoleculesDescriptors.BuildingBlockDescriptors.EntityDescriptor.isBuildingBlock(field.getRawType())) {
            return Optional.of(field.getRawType());
        }
        if (this.isCollection(field) && (fieldType = field.getType()) instanceof JavaParameterizedType && !(actualTypeArguments = ((JavaParameterizedType)fieldType).getActualTypeArguments()).isEmpty() && JMoleculesDescriptors.BuildingBlockDescriptors.EntityDescriptor.isBuildingBlock(javaClass = ((JavaType)actualTypeArguments.get(0)).toErasure())) {
            return Optional.of(javaClass);
        }
        if (this.isMap(field) && (fieldType = field.getType()) instanceof JavaParameterizedType && (actualTypeArguments = ((JavaParameterizedType)fieldType).getActualTypeArguments()).size() > 1 && JMoleculesDescriptors.BuildingBlockDescriptors.EntityDescriptor.isBuildingBlock(javaClass = ((JavaType)actualTypeArguments.get(1)).toErasure())) {
            return Optional.of(javaClass);
        }
        return Optional.empty();
    }
}

