/*
 * Decompiled with CFR 0.152.
 */
package compozitor.engine.core.interfaces;

import com.google.common.io.CharStreams;
import compozitor.engine.core.interfaces.PluginRepository;
import compozitor.engine.core.interfaces.SourceCodeListener;
import compozitor.generator.core.interfaces.CodeGenerationCategory;
import compozitor.generator.core.interfaces.CodeGenerationCategoryContext;
import compozitor.generator.core.interfaces.CodeGenerationCategoryEngine;
import compozitor.generator.core.interfaces.GeneratedCode;
import compozitor.generator.core.interfaces.MetaModelRepository;
import compozitor.generator.core.interfaces.TemplateRepository;
import compozitor.processor.core.interfaces.AnnotationProcessor;
import compozitor.processor.core.interfaces.FieldModel;
import compozitor.processor.core.interfaces.Logger;
import compozitor.processor.core.interfaces.MethodModel;
import compozitor.processor.core.interfaces.ProcessingContext;
import compozitor.processor.core.interfaces.TypeModel;
import compozitor.template.core.interfaces.TemplateContextData;
import compozitor.template.core.interfaces.TemplateEngine;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public abstract class ProcessorEngine<T extends TemplateContextData<T>>
extends AnnotationProcessor {
    private final PluginRepository pluginRepository = PluginRepository.create();
    private final MetaModelRepository<T> metaModelRepository = new MetaModelRepository();
    private SourceCodeListener generatorListener;

    protected void init(ProcessingContext context) {
        this.pluginRepository.load(this.getClassLoader(), this.category(), (Logger)context);
        this.generatorListener = sourceCode -> {};
    }

    protected final void process(FieldModel fieldModel) {
        this.metaModelRepository.add(this.pluginRepository.getMetaModel(this.context, fieldModel));
    }

    protected final void process(MethodModel methodModel) {
        this.metaModelRepository.add(this.pluginRepository.getMetaModel(this.context, methodModel));
    }

    protected final void process(TypeModel typeModel) {
        this.metaModelRepository.add(this.pluginRepository.getMetaModel(this.context, typeModel));
    }

    protected void postProcess() {
        CodeGenerationCategoryContext engineContext = CodeGenerationCategoryContext.create();
        engineContext.add(this.category(), this.metaModelRepository);
        TemplateEngine templateEngine = this.pluginRepository.templateEngine();
        TemplateRepository templates = this.pluginRepository.templates(templateEngine);
        templates.forEach(template -> engineContext.add(this.category(), template));
        CodeGenerationCategoryEngine engine = CodeGenerationCategoryEngine.create();
        engine.generate(templateEngine, engineContext, code -> this.write(code));
    }

    private void write(GeneratedCode code) {
        try {
            String sourceCode = CharStreams.toString((Readable)new InputStreamReader(code.getContent()));
            this.generatorListener.accept(sourceCode);
            FileObject sourceFile = this.createFile(code);
            this.context.info("Generating file {0}", new Object[]{sourceFile.getName()});
            try (Writer writer = sourceFile.openWriter();){
                writer.write(sourceCode);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private FileObject createFile(GeneratedCode code) throws IOException {
        if (code.getResource().booleanValue()) {
            return this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, (CharSequence)code.getNamespace().toString(), (CharSequence)code.getFileName().toString(), new Element[0]);
        }
        return this.context.createSourceFile((CharSequence)code.getQualifiedName().toString(), new Element[0]);
    }

    public final void listen(SourceCodeListener generatorListener) {
        this.generatorListener = generatorListener;
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected abstract CodeGenerationCategory category();
}

