/*
 * Decompiled with CFR 0.152.
 */
package compozitor.engine.core.interfaces;

import com.google.common.io.CharStreams;
import compozitor.engine.core.interfaces.PluginRepository;
import compozitor.engine.core.interfaces.SourceCodeListener;
import compozitor.generator.core.interfaces.CodeGenerationCategory;
import compozitor.generator.core.interfaces.CodeGenerationCategoryContext;
import compozitor.generator.core.interfaces.CodeGenerationCategoryEngine;
import compozitor.generator.core.interfaces.GeneratedCode;
import compozitor.generator.core.interfaces.MetaModelRepository;
import compozitor.generator.core.interfaces.TemplateRepository;
import compozitor.processor.core.interfaces.AnnotationProcessor;
import compozitor.processor.core.interfaces.FieldModel;
import compozitor.processor.core.interfaces.JavaFileName;
import compozitor.processor.core.interfaces.JavaResource;
import compozitor.processor.core.interfaces.JavaResources;
import compozitor.processor.core.interfaces.Logger;
import compozitor.processor.core.interfaces.MethodModel;
import compozitor.processor.core.interfaces.Name;
import compozitor.processor.core.interfaces.PackageName;
import compozitor.processor.core.interfaces.ProcessingContext;
import compozitor.processor.core.interfaces.ResourceName;
import compozitor.processor.core.interfaces.TypeModel;
import compozitor.template.core.infra.CompositeClassLoader;
import compozitor.template.core.interfaces.TemplateContextData;
import compozitor.template.core.interfaces.TemplateEngine;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.tools.FileObject;

public abstract class ProcessorEngine<T extends TemplateContextData<T>>
extends AnnotationProcessor {
    private final PluginRepository pluginRepository = PluginRepository.create();
    private final MetaModelRepository<T> metaModelRepository = MetaModelRepository.create();
    private final CompositeClassLoader classLoader = CompositeClassLoader.create().join(((Object)((Object)this)).getClass().getClassLoader());
    private SourceCodeListener generatorListener;

    protected void init(ProcessingContext context) {
        this.joinClassLoader(this.classLoader);
        this.pluginRepository.load((ClassLoader)this.classLoader, this.category(), (Logger)context);
        this.generatorListener = sourceCode -> {};
    }

    protected final void process(FieldModel fieldModel) {
        this.metaModelRepository.add(this.pluginRepository.getMetaModel(this.context, this.repository, fieldModel));
    }

    protected final void process(MethodModel methodModel) {
        this.metaModelRepository.add(this.pluginRepository.getMetaModel(this.context, this.repository, methodModel));
    }

    protected final void process(TypeModel typeModel) {
        this.metaModelRepository.add(this.pluginRepository.getMetaModel(this.context, this.repository, typeModel));
    }

    protected final void postProcess() {
        CodeGenerationCategoryContext engineContext = CodeGenerationCategoryContext.create();
        engineContext.add(this.category(), this.metaModelRepository);
        TemplateEngine templateEngine = this.pluginRepository.templateEngine();
        TemplateRepository templates = this.pluginRepository.templates(templateEngine);
        templates.forEach(template -> engineContext.add(this.category(), template));
        CodeGenerationCategoryEngine engine = CodeGenerationCategoryEngine.create();
        engine.generate(templateEngine, engineContext, code -> this.write(code));
        this.postGeneration(this.metaModelRepository);
        this.metaModelRepository.clear();
    }

    protected void postGeneration(MetaModelRepository<T> repository) {
    }

    protected void processOver() {
        this.pluginRepository.releaseResources(this.context);
    }

    private void write(GeneratedCode code) {
        try {
            String sourceCode = CharStreams.toString((Readable)new InputStreamReader(code.getContent()));
            this.generatorListener.accept(sourceCode);
            FileObject sourceFile = this.createFile(code);
            this.context.info("Generating file {0}", new Object[]{sourceFile.getName()});
            try (Writer writer = sourceFile.openWriter();){
                writer.write(sourceCode);
            }
        }
        catch (IOException e) {
            this.context.warning("Was not possible to write generated code with message {0}", new Object[]{e.getMessage()});
        }
    }

    private FileObject createFile(GeneratedCode code) throws IOException {
        if (code.getResource().booleanValue()) {
            Path path = Paths.get(code.getNamespace().toPath().toString(), code.getFileName().toString());
            ResourceName resourceName = ResourceName.create((String)path.toString());
            JavaResource javaResource = JavaResources.create((Name)resourceName);
            return this.context.getJavaFiles().resourceFile(javaResource);
        }
        PackageName packageName = PackageName.create((String)code.getNamespace().toString());
        JavaFileName javaFileName = JavaFileName.create((String)code.getFileName().toString());
        JavaResource javaResource = JavaResources.create((PackageName)packageName, (JavaFileName)javaFileName);
        return this.context.getJavaFiles().sourceFile(javaResource);
    }

    public final void listen(SourceCodeListener generatorListener) {
        this.generatorListener = generatorListener;
    }

    protected void joinClassLoader(CompositeClassLoader classLoader) {
    }

    protected abstract CodeGenerationCategory category();
}

