/*
 * Decompiled with CFR 0.152.
 */
package compozitor.engine.core.interfaces;

import compozitor.engine.core.interfaces.CodeGenerationCategoryPlugin;
import compozitor.engine.core.interfaces.FieldModelPlugin;
import compozitor.engine.core.interfaces.MethodModelPlugin;
import compozitor.engine.core.interfaces.TemplateEnginePlugin;
import compozitor.engine.core.interfaces.TemplatePlugin;
import compozitor.engine.core.interfaces.TypeModelPlugin;
import compozitor.generator.core.interfaces.CodeGenerationCategory;
import compozitor.generator.core.interfaces.TemplateRepository;
import compozitor.processor.core.interfaces.AnnotationRepository;
import compozitor.processor.core.interfaces.FieldModel;
import compozitor.processor.core.interfaces.Logger;
import compozitor.processor.core.interfaces.MethodModel;
import compozitor.processor.core.interfaces.ProcessingContext;
import compozitor.processor.core.interfaces.TypeModel;
import compozitor.template.core.interfaces.TemplateContextData;
import compozitor.template.core.interfaces.TemplateEngine;
import compozitor.template.core.interfaces.TemplateEngineBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Consumer;

class PluginRepository {
    private final Collection<TemplateEnginePlugin> templateEnginePlugins = new ArrayList<TemplateEnginePlugin>();
    private final Collection<TypeModelPlugin<?>> typeModelPlugins = new ArrayList();
    private final Collection<FieldModelPlugin<?>> fieldModelPlugins = new ArrayList();
    private final Collection<MethodModelPlugin<?>> methodModelPlugins = new ArrayList();
    private final Collection<TemplatePlugin> templatePlugins = new ArrayList<TemplatePlugin>();

    PluginRepository() {
    }

    static PluginRepository create() {
        return new PluginRepository();
    }

    void load(ClassLoader classLoader, CodeGenerationCategory category, Logger logger) {
        logger.info("Loading plugins for category {0}", new Object[]{category.getClass().getName()});
        ServiceLoader.load(TemplateEnginePlugin.class, classLoader).forEach(plugin -> this.accept((CodeGenerationCategoryPlugin)plugin, category, accepted -> {
            logger.info("Loading template engine plugin {0}", new Object[]{plugin.getClass().getCanonicalName()});
            this.templateEnginePlugins.add((TemplateEnginePlugin)plugin);
        }));
        ServiceLoader.load(TypeModelPlugin.class, classLoader).forEach(plugin -> this.accept((CodeGenerationCategoryPlugin)plugin, category, accepted -> {
            logger.info("Loading type model plugin {0}", new Object[]{plugin.getClass().getCanonicalName()});
            this.typeModelPlugins.add((TypeModelPlugin<?>)plugin);
        }));
        ServiceLoader.load(FieldModelPlugin.class, classLoader).forEach(plugin -> this.accept((CodeGenerationCategoryPlugin)plugin, category, accepted -> {
            logger.info("Loading field model plugin {0}", new Object[]{plugin.getClass().getCanonicalName()});
            this.fieldModelPlugins.add((FieldModelPlugin<?>)plugin);
        }));
        ServiceLoader.load(MethodModelPlugin.class, classLoader).forEach(plugin -> this.accept((CodeGenerationCategoryPlugin)plugin, category, accepted -> {
            logger.info("Loading method model plugin {0}", new Object[]{plugin.getClass().getCanonicalName()});
            this.methodModelPlugins.add((MethodModelPlugin<?>)plugin);
        }));
        ServiceLoader.load(TemplatePlugin.class, classLoader).forEach(plugin -> this.accept((CodeGenerationCategoryPlugin)plugin, category, accepted -> {
            logger.info("Loading template plugin {0}", new Object[]{plugin.getClass().getCanonicalName()});
            this.templatePlugins.add((TemplatePlugin)plugin);
        }));
    }

    private void accept(CodeGenerationCategoryPlugin plugin, CodeGenerationCategory category, Consumer<CodeGenerationCategoryPlugin> accepted) {
        if (plugin.category().equals(category)) {
            accepted.accept(plugin);
        }
    }

    public TemplateEngine templateEngine() {
        TemplateEngineBuilder builder = TemplateEngineBuilder.create().addClassLoader(this.getClass().getClassLoader()).withClasspathTemplateLoader();
        this.templateEnginePlugins.forEach(plugin -> plugin.accept(builder));
        return builder.build();
    }

    public TemplateRepository templates(TemplateEngine templateEngine) {
        TemplateRepository templateRepository = TemplateRepository.create();
        this.templatePlugins.forEach(plugin -> plugin.accept(templateEngine, templateRepository));
        return templateRepository;
    }

    public <T extends TemplateContextData<T>> Collection<T> getMetaModel(ProcessingContext context, AnnotationRepository annotationRepository, TypeModel model) {
        ArrayList metaModelList = new ArrayList();
        this.typeModelPlugins.forEach(plugin -> {
            plugin.accept(context, annotationRepository);
            metaModelList.addAll(plugin.collect(context, model));
            Object accepted = plugin.accept(context, model);
            if (accepted != null) {
                metaModelList.add(accepted);
            }
        });
        return metaModelList;
    }

    public <T extends TemplateContextData<T>> Collection<T> getMetaModel(ProcessingContext context, AnnotationRepository annotationRepository, FieldModel model) {
        ArrayList metaModelList = new ArrayList();
        this.fieldModelPlugins.forEach(plugin -> {
            plugin.accept(context, annotationRepository);
            metaModelList.addAll(plugin.collect(context, model));
            Object accepted = plugin.accept(context, model);
            if (accepted != null) {
                metaModelList.add(accepted);
            }
        });
        return metaModelList;
    }

    public <T extends TemplateContextData<T>> Collection<T> getMetaModel(ProcessingContext context, AnnotationRepository annotationRepository, MethodModel model) {
        ArrayList metaModelList = new ArrayList();
        this.methodModelPlugins.forEach(plugin -> {
            plugin.accept(context, annotationRepository);
            metaModelList.addAll(plugin.collect(context, model));
            Object accepted = plugin.accept(context, model);
            if (accepted != null) {
                metaModelList.add(accepted);
            }
        });
        return metaModelList;
    }

    public void releaseResources(ProcessingContext context) {
        this.typeModelPlugins.forEach(plugin -> plugin.release(context));
        this.fieldModelPlugins.forEach(plugin -> plugin.release(context));
        this.methodModelPlugins.forEach(plugin -> plugin.release(context));
    }
}

