/*
 * Decompiled with CFR 0.152.
 */
package compozitor.template.core.infra;

import compozitor.template.core.infra.JoinableClassLoader;
import compozitor.template.core.infra.ResourceUri;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.stream.Stream;

public class MacrosLoader {
    private JoinableClassLoader classLoader;

    MacrosLoader(JoinableClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static MacrosLoader create(JoinableClassLoader classLoader) {
        return new MacrosLoader(classLoader);
    }

    public Stream<String> list(Path path) {
        File directory = path.toFile();
        if (directory.exists()) {
            return this.listFromDirectory(path).map(it -> it.getFileName().toString());
        }
        HashSet<String> resources = new HashSet<String>();
        try {
            String resourceName = path.toString();
            if (resourceName.startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            Enumeration<URL> urls = this.classLoader.getResources(resourceName);
            while (urls.hasMoreElements()) {
                InputStream classPath = urls.nextElement().openStream();
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(classPath));
                    Throwable throwable2 = null;
                    try {
                        String resource = null;
                        while ((resource = reader.readLine()) != null) {
                            String resourceFile = new ResourceUri(path.toString(), resource).toString();
                            resources.add(resourceFile);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (classPath == null) continue;
                    if (throwable != null) {
                        try {
                            classPath.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    classPath.close();
                }
            }
            return resources.stream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<Path> listFromDirectory(Path path) {
        try {
            return Files.list(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

