/*
 * Decompiled with CFR 0.152.
 */
package compozitor.template.core.interfaces;

import compozitor.template.core.interfaces.Template;
import compozitor.template.core.interfaces.TemplateEngine;
import compozitor.template.core.interfaces.TemplateEngineBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import toolbox.resources.interfaces.StringInputStream;

public class TemplateBuilder {
    private final org.apache.velocity.Template target = new org.apache.velocity.Template();

    private TemplateBuilder(String name, TemplateEngine templateEngine) {
        this.target.setRuntimeServices(templateEngine.getRuntimeServices());
        this.target.setName(name);
    }

    public static TemplateBuilder create(String templateName) {
        return new TemplateBuilder(templateName, TemplateEngineBuilder.create().build());
    }

    public static TemplateBuilder create(TemplateEngine templateEngine, String templateName) {
        return new TemplateBuilder(templateName, templateEngine);
    }

    public TemplateBuilder withResourceLoader(File file) {
        try {
            byte[] fileBytes = Files.readAllBytes(file.toPath());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
            return this.withResourceLoader(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TemplateBuilder withResourceLoader(String loader) {
        return this.withResourceLoader((InputStream)new StringInputStream(loader));
    }

    public TemplateBuilder withResourceLoader(byte[] bytes) {
        return this.withResourceLoader(new ByteArrayInputStream(bytes));
    }

    public TemplateBuilder withResourceLoader(InputStream inputStream) {
        this.target.setResourceLoader((ResourceLoader)new InputStreamLoader(inputStream));
        return this;
    }

    public Template build() {
        try {
            this.target.process();
            return new Template(this.target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class InputStreamLoader
    extends ResourceLoader {
        private InputStream input;

        public InputStreamLoader(InputStream input) {
            this.input = input;
        }

        public long getLastModified(Resource resource) {
            return 0L;
        }

        public InputStream getResourceStream(String resource) throws ResourceNotFoundException {
            return this.input;
        }

        public void init(ExtendedProperties properties) {
        }

        public boolean isSourceModified(Resource resource) {
            return false;
        }
    }
}

