/*
 * Decompiled with CFR 0.152.
 */
package compozitor.template.core.infra;

import java.io.InputStream;

public class StringInputStream
extends InputStream {
    private final String value;
    private int index = 0;

    public StringInputStream(String value) {
        this.value = value;
    }

    @Override
    public int available() {
        return this.value.length() - this.index;
    }

    @Override
    public int read() {
        if (this.index == this.value.length()) {
            return -1;
        }
        return this.value.charAt(this.index++);
    }

    @Override
    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) {
        if (this.index == this.value.length()) {
            return -1;
        }
        len = Math.min(len, this.available());
        for (int i = 0; i < len; ++i) {
            buf[i + offset] = (byte)this.value.charAt(this.index++);
        }
        return len;
    }
}

