/*
 * Decompiled with CFR 0.152.
 */
package compozitor.processor.core.interfaces;

import com.google.testing.compile.Compilation;
import java.io.IOException;
import java.io.InputStream;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class FileObjectStringfy {
    private final Compilation compilation;

    public String sourceToString(String path) {
        String resourceNotFound = String.format("Resource not found %s", path);
        FileObject generatedFile = (FileObject)this.compilation.generatedFile((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, path).orElseThrow(() -> new RuntimeException(resourceNotFound));
        return FileObjectStringfy.toString(generatedFile);
    }

    public String resourceToString(String path) {
        String resourceNotFound = String.format("Resource not found %s", path);
        FileObject generatedFile = (FileObject)this.compilation.generatedFile((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, path).orElseThrow(() -> new RuntimeException(resourceNotFound));
        return FileObjectStringfy.toString(generatedFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(FileObject javaFile) {
        try (InputStream input = javaFile.openInputStream();){
            byte[] available = new byte[input.available()];
            input.read(available);
            String string = new String(available);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private FileObjectStringfy(Compilation compilation) {
        this.compilation = compilation;
    }

    public static FileObjectStringfy create(Compilation compilation) {
        return new FileObjectStringfy(compilation);
    }
}

