/*
 * Decompiled with CFR 0.152.
 */
package compozitor.processor.core.interfaces;

import com.google.testing.compile.Compilation;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileObject;

public class CompilationBuilder {
    private final List<Processor> processors = new ArrayList<Processor>();
    private final List<JavaFileObject> javaSource = new ArrayList<JavaFileObject>();

    public static CompilationBuilder create() {
        return new CompilationBuilder();
    }

    public CompilationBuilder withProcessors(Processor ... processors) {
        Objects.requireNonNull(processors);
        this.processors.addAll(Arrays.asList(processors));
        return this;
    }

    public CompilationBuilder withJavaSource(String resourceName) {
        return this.withJavaSources(resourceName);
    }

    public CompilationBuilder withJavaSources(String ... resourceName) {
        Objects.requireNonNull(resourceName);
        Arrays.asList(resourceName).forEach(javaSourceName -> this.javaSource.add(JavaFileObjects.forResource((String)javaSourceName)));
        return this;
    }

    public Compilation build() {
        return Compiler.javac().withProcessors(this.processors).compile(this.javaSource);
    }
}

