/*
 * Decompiled with CFR 0.152.
 */
package compozitor.processor.core.interfaces;

import com.google.common.io.CharStreams;
import compozitor.processor.core.interfaces.FileObjectStringfy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.tools.JavaFileObject;
import org.junit.Assert;

public class FileAssertion {
    private final String content;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileAssertion withResourceFile(String path) {
        String resourcePath = path;
        if (!path.startsWith("/")) {
            resourcePath = "/" + path;
        }
        try (InputStream resourceFile = FileAssertion.class.getResourceAsStream(resourcePath);){
            String content = CharStreams.toString((Readable)new InputStreamReader(resourceFile));
            FileAssertion fileAssertion = new FileAssertion(content);
            return fileAssertion;
        }
        catch (IOException e) {
            throw new RuntimeException("Resource file not found at " + path);
        }
    }

    public void assertEquals(JavaFileObject javaFile) {
        Assert.assertEquals((Object)this.content, (Object)FileObjectStringfy.toString(javaFile));
    }

    public void assertEquals(String content) {
        Assert.assertEquals((Object)this.content, (Object)content);
    }

    FileAssertion(String content) {
        this.content = content;
    }
}

