/*
 * Decompiled with CFR 0.152.
 */
package legolas.common.interfaces;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resources {
    private final Logger logger = LoggerFactory.getLogger(Resources.class);
    private final ClassLoader classLoader;
    private final Charset charset;

    public Resources(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.charset = StandardCharsets.UTF_8;
    }

    public static Resources create() {
        return Resources.create(Thread.currentThread().getContextClassLoader());
    }

    public static Resources create(ClassLoader classLoader) {
        return new Resources(classLoader);
    }

    public Optional<String> read(Path path) {
        String content = this.openResourceAsString(path);
        if (content == null) {
            content = this.openFileAsString(path);
        }
        return Optional.ofNullable(content);
    }

    private String openFileAsString(Path path) {
        File file = new File(path.toUri());
        if (!file.exists()) {
            this.logger.info("File does not exists on path {}", (Object)path.toString());
            return null;
        }
        try {
            byte[] available = Files.readAllBytes(path);
            return this.toString(available);
        }
        catch (IOException e) {
            this.log(path, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String openResourceAsString(Path path) {
        try (InputStream inputStream = this.openResourceStream(path);){
            if (inputStream == null) {
                String string2 = null;
                return string2;
            }
            byte[] available = new byte[inputStream.available()];
            inputStream.read(available);
            String string = new String(available);
            return string;
        }
        catch (IOException e) {
            this.log(path, e);
            return null;
        }
    }

    private void log(Path path, IOException e) {
        this.logger.warn("It was not possible to read file on path {}", (Object)path.toString());
        this.logger.warn("Read error ", (Throwable)e);
    }

    private String toString(byte[] bytes) {
        return new String(bytes, this.charset);
    }

    private InputStream openResourceStream(Path path) {
        return this.classLoader.getResourceAsStream(path.toString());
    }
}

