/*
 * Decompiled with CFR 0.152.
 */
package legolas.config.api.interfaces;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import legolas.config.api.interfaces.Entry;

public class Configuration {
    private final Map<String, Object> values;

    public static Configuration create(Properties properties) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        properties.entrySet().forEach(entry -> configMap.put(entry.getKey().toString(), entry.getValue()));
        return Configuration.create(configMap);
    }

    public static Configuration create() {
        return new Configuration(new HashMap<String, Object>());
    }

    public Configuration set(Entry entry, Object value) {
        this.values.put(entry.value(), value);
        return this;
    }

    public Optional<Object> getObject(Entry entry) {
        return Optional.ofNullable(this.values.get(entry.value()));
    }

    public Optional<Boolean> getBoolean(Entry entry) {
        return Optional.ofNullable(this.get(entry));
    }

    public Optional<Number> getNumber(Entry entry) {
        Object value = this.values.get(entry.value());
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof String) {
            return Optional.of(Integer.valueOf((String)value));
        }
        return Optional.of((Number)value);
    }

    public Optional<String> getString(Entry entry) {
        Object value = this.values.get(entry.value());
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Number) {
            String toStringValue = String.valueOf(((Number)value).intValue());
            return Optional.of(toStringValue);
        }
        return Optional.of(value.toString());
    }

    private <T> T get(Entry entry) {
        return (T)this.values.get(entry.value());
    }

    private Configuration(Map<String, Object> values) {
        this.values = values;
    }

    public static Configuration create(Map<String, Object> values) {
        return new Configuration(values);
    }
}

