/*
 * Decompiled with CFR 0.152.
 */
package legolas.common.interfaces;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import toolbox.resources.interfaces.ResourceStream;

public class Resources {
    private final Logger logger = LoggerFactory.getLogger(Resources.class);
    private final ResourceStream resourceStream;

    public Resources(ClassLoader classLoader) {
        this.resourceStream = ResourceStream.create((ClassLoader)classLoader);
    }

    public static Resources create() {
        return Resources.create(Thread.currentThread().getContextClassLoader());
    }

    public static Resources create(ClassLoader classLoader) {
        return new Resources(classLoader);
    }

    public Optional<String> read(Path path) {
        String content = this.openFileAsString(path);
        if (content == null) {
            content = this.openResourceAsString(path);
        }
        return Optional.ofNullable(content);
    }

    private String openFileAsString(Path path) {
        File file = new File(path.toUri());
        if (!file.exists()) {
            this.logger.info("File does not exists on path {}. Reading from classpath.", (Object)path.toString());
            return null;
        }
        try {
            byte[] available = Files.readAllBytes(path);
            return this.resourceStream.toString(available);
        }
        catch (IOException e) {
            this.log(path, e);
            return null;
        }
    }

    private String openResourceAsString(Path path) {
        return this.resourceStream.read(path).orElse(null);
    }

    private void log(Path path, IOException e) {
        this.logger.warn("It was not possible to read file on path {}", (Object)path.toString());
        this.logger.warn("Read error ", (Throwable)e);
    }
}

