/*
 * Decompiled with CFR 0.152.
 */
package legolas.net.core.interfaces;

public class Port {
    private static final int ANY_PORT_VALUE = -1;
    private final Integer value;

    public static Port anyPort() {
        return Port.create(-1);
    }

    public Integer value() {
        return this.value;
    }

    public Boolean any() {
        return this.value == -1;
    }

    public Port next() {
        return Port.create(this.value + 1);
    }

    public String toBinding() {
        return String.format("%d:%d", this.value, this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    private Port(Integer value) {
        this.value = value;
    }

    public static Port create(Integer value) {
        return new Port(value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Port)) {
            return false;
        }
        Port other = (Port)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$value = this.value;
        Integer other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Port;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

