/*
 * Decompiled with CFR 0.152.
 */
package legolas.runtime.core.interfaces;

import legolas.async.api.interfaces.Promise;
import legolas.config.api.interfaces.Configuration;
import legolas.runtime.core.interfaces.BootstrapRunner;
import legolas.runtime.core.interfaces.MigrationRunner;
import legolas.runtime.core.interfaces.RunningEnvironment;
import legolas.runtime.core.interfaces.RuntimeEnvironment;
import legolas.runtime.core.interfaces.StarterRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifecycleEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(LifecycleEnvironment.class);

    final void start(RuntimeEnvironment runtimeEnvironment, Configuration configuration, Promise<RunningEnvironment> promise) {
        try {
            RunningEnvironment environment = RunningEnvironment.create(runtimeEnvironment, configuration);
            this.run(environment);
            promise.complete(environment);
        }
        catch (RuntimeException e) {
            promise.fail(e);
        }
    }

    protected abstract void run(RunningEnvironment var1);

    protected void bootstrappers(RunningEnvironment environment) {
        logger.info("Running bootstrapers...");
        new BootstrapRunner().run(environment);
    }

    protected void migrations(RunningEnvironment environment) {
        logger.info("Running migrations...");
        new MigrationRunner().run(environment);
    }

    protected void starters(RunningEnvironment environment) {
        logger.info("Running starters...");
        new StarterRunner().run(environment);
    }
}

