/*
 * Decompiled with CFR 0.152.
 */
package legolas.runtime.core.interfaces;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import legolas.config.api.interfaces.Configuration;
import legolas.runtime.core.interfaces.RunningInstance;
import legolas.runtime.core.interfaces.RuntimeEnvironment;
import legolas.runtime.core.interfaces.ServiceId;

public class RunningEnvironment {
    private final RuntimeEnvironment runtime;
    private final Map<String, RunningInstance> instances;
    private final Configuration configuration;

    private RunningEnvironment(RuntimeEnvironment runtime, Configuration configuration) {
        this.runtime = runtime;
        this.instances = new HashMap<String, RunningInstance>();
        this.configuration = configuration;
    }

    static RunningEnvironment create(RuntimeEnvironment runtime, Configuration configuration) {
        return new RunningEnvironment(runtime, configuration);
    }

    public RuntimeEnvironment runtimeEnvironment() {
        return this.runtime;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public RunningEnvironment add(RunningInstance instance) {
        this.instances.put(instance.id().value(), instance);
        return this;
    }

    public <T extends RunningInstance> Optional<T> get(ServiceId id) {
        return Optional.ofNullable(this.instances.get(id.value()));
    }
}

