/*
 * Decompiled with CFR 0.152.
 */
package legolas.runtime.core.interfaces;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ServiceLoader;
import legolas.migration.api.interfaces.Migration;
import legolas.runtime.core.interfaces.MigrationTask;
import legolas.runtime.core.interfaces.RunningEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationRunner {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRunner.class);

    MigrationRunner() {
    }

    public void run(RunningEnvironment environment) {
        HashMap tasks = new HashMap();
        ServiceLoader.load(Migration.class).forEach(service -> tasks.put(service.id().value(), MigrationTask.of(service)));
        if (tasks.isEmpty()) {
            return;
        }
        ArrayList dependentTasks = new ArrayList();
        tasks.values().forEach(task -> task.dependsOn().ifPresent(id -> {
            ((MigrationTask)tasks.get(id.value())).add((MigrationTask)task);
            dependentTasks.add(task);
        }));
        dependentTasks.forEach(task -> tasks.remove(task.id().value()));
        tasks.values().forEach(task -> {
            logger.info("Running migration {}", (Object)task.id().value());
            task.run(environment);
        });
    }
}

