/*
 * Decompiled with CFR 0.152.
 */
package legolas.runtime.core.interfaces;

import java.util.ServiceLoader;
import legolas.config.api.interfaces.Configuration;
import legolas.net.core.interfaces.LocalPortBinding;
import legolas.runtime.core.interfaces.RunningEnvironment;
import legolas.runtime.core.interfaces.RunningInstance;
import legolas.runtime.core.interfaces.RuntimeEnvironment;
import legolas.starter.api.interfaces.PortStarter;
import legolas.starter.api.interfaces.Starter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StarterRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    StarterRunner() {
    }

    public void run(RunningEnvironment environment) {
        ServiceLoader.load(Starter.class).forEach(service -> {
            this.logger.info("{} initializing", (Object)service.name());
            RuntimeEnvironment runtimeEnvironment = environment.runtimeEnvironment();
            Configuration configuration = service.configuration();
            environment.add(RunningInstance.create(service.id(), configuration));
            boolean shouldStart = true;
            if (service instanceof PortStarter) {
                shouldStart = this.shouldStart((PortStarter)service, runtimeEnvironment);
            }
            if (shouldStart) {
                service.start(runtimeEnvironment);
                return;
            }
            service.attach(runtimeEnvironment);
        });
    }

    private boolean shouldStart(PortStarter starter, RuntimeEnvironment runtimeEnvironment) {
        if (runtimeEnvironment == RuntimeEnvironment.TEST) {
            starter.stop();
        }
        LocalPortBinding localPortBinding = LocalPortBinding.create(starter.socketType());
        return starter.ports().allMatch(localPortBinding.availablePredicate());
    }
}

