/*
 * Decompiled with CFR 0.152.
 */
package legolas.runtime.core.interfaces;

import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import legolas.bootstrapper.api.interfaces.Bootstrapper;
import legolas.bootstrapper.api.interfaces.NetworkBootstrapper;
import legolas.config.api.interfaces.Configuration;
import legolas.net.core.interfaces.LocalPortBinding;
import legolas.net.core.interfaces.Port;
import legolas.runtime.core.interfaces.RunningEnvironment;
import legolas.runtime.core.interfaces.RunningInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BootstrapRunner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    BootstrapRunner() {
    }

    public void run(RunningEnvironment environment) {
        ServiceLoader.load(Bootstrapper.class).forEach(service -> {
            this.logger.info("{} initializing", (Object)service.name());
            RunningInstance instance = null;
            if (service instanceof NetworkBootstrapper) {
                environment.add(this.bootstrap((NetworkBootstrapper)((Object)service)));
            } else {
                environment.add(this.bootstrap((Bootstrapper)service, environment.configuration()));
                this.logger.info("{} started", (Object)service.name());
            }
            environment.add(instance);
        });
    }

    private RunningInstance bootstrap(Bootstrapper bootstrapper, Configuration configuration) {
        Object reference = bootstrapper.bootstrap(configuration);
        this.logger.info("{} properly bootstrapped", (Object)bootstrapper.name());
        return RunningInstance.create(bootstrapper.id(), configuration, reference);
    }

    private RunningInstance bootstrap(NetworkBootstrapper service) {
        LocalPortBinding localPortBinding = LocalPortBinding.create(service.socketType());
        ArrayList availablePorts = new ArrayList();
        service.ports().forEach(port -> availablePorts.add(localPortBinding.nextPortAvailable((Port)port)));
        Configuration configuration = service.bootstrap(availablePorts.stream());
        this.logger.info("{} started using ports {}", (Object)service.name(), (Object)availablePorts.stream().map(port -> port.toString()).collect(Collectors.joining(",")));
        return RunningInstance.create(service.id(), configuration);
    }
}

