/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.infra;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import migrami.core.interfaces.ResourceName;

public class ResourceStream {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(Path path, ResourceName resourceName) {
        String resourceLocation = Paths.get(path.toString(), resourceName.toString()).toString();
        try (InputStream input = ResourceStream.stream(path, resourceName);){
            byte[] buffer = new byte[input.available()];
            input.read(buffer);
            String string = new String(buffer);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] readBytes(InputStream inputStream) {
        try {
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            return buffer;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static InputStream stream(Path path, ResourceName resourceName) {
        String resourceLocation = Paths.get(path.toString(), resourceName.toString()).toString();
        return ResourceStream.class.getClassLoader().getResourceAsStream(resourceLocation);
    }
}

