/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.interfaces;

import migrami.core.interfaces.MigramiScriptNameViolationException;
import migrami.core.interfaces.MigramiVersion;
import migrami.core.interfaces.ResourceName;

public class MigramiScriptName
implements Comparable<MigramiScriptName> {
    private final String value;
    private final MigramiVersion version;
    private final String description;

    public static MigramiScriptName create(ResourceName resourceName) {
        String nameURI = resourceName.toString();
        if (!nameURI.startsWith("V")) {
            throw new MigramiScriptNameViolationException("Script name should start with V.");
        }
        if (!nameURI.contains("_")) {
            throw new MigramiScriptNameViolationException("Script name should have the description in its name.");
        }
        int underlineIndex = nameURI.indexOf("_");
        String version = nameURI.substring(0, underlineIndex);
        String description = nameURI.substring(underlineIndex + 1);
        return new MigramiScriptName(nameURI, MigramiVersion.create(version), description);
    }

    @Override
    public int compareTo(MigramiScriptName name) {
        return this.version.compareTo(name.version);
    }

    public MigramiVersion version() {
        return this.version;
    }

    public String description() {
        return this.description;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    private MigramiScriptName(String value, MigramiVersion version, String description) {
        this.value = value;
        this.version = version;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigramiScriptName)) {
            return false;
        }
        MigramiScriptName other = (MigramiScriptName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigramiScriptName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

