/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.interfaces;

import java.io.InputStream;
import migrami.core.interfaces.MigramiCategory;
import migrami.core.interfaces.MigramiChecksum;
import migrami.core.interfaces.MigramiChecksumFactory;
import migrami.core.interfaces.MigramiScriptBody;
import migrami.core.interfaces.MigramiScriptName;
import migrami.core.interfaces.MigramiVersion;
import migrami.core.interfaces.ResourceName;

public class MigramiScript {
    private final MigramiCategory category;
    private final MigramiScriptName name;
    private final MigramiScriptBody body;
    private final MigramiChecksum checksum;

    public static MigramiScript create(MigramiCategory category, MigramiChecksumFactory checksumFactory, ResourceName resourceName, InputStream content) {
        MigramiScriptBody body = MigramiScriptBody.create(content);
        MigramiChecksum checksum = checksumFactory.create(body.toString());
        MigramiScriptName name = MigramiScriptName.create(resourceName);
        return new MigramiScript(category, name, body, checksum);
    }

    public MigramiCategory category() {
        return this.category;
    }

    public MigramiScriptBody body() {
        return this.body;
    }

    public MigramiChecksum checksum() {
        return this.checksum;
    }

    public String description() {
        return this.name.description();
    }

    public MigramiVersion version() {
        return this.name.version();
    }

    public MigramiScriptName name() {
        return this.name;
    }

    public String toString() {
        return this.name().toString();
    }

    private MigramiScript(MigramiCategory category, MigramiScriptName name, MigramiScriptBody body, MigramiChecksum checksum) {
        this.category = category;
        this.name = name;
        this.body = body;
        this.checksum = checksum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigramiScript)) {
            return false;
        }
        MigramiScript other = (MigramiScript)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MigramiCategory this$category = this.category;
        MigramiCategory other$category = other.category;
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        MigramiScriptName this$name = this.name;
        MigramiScriptName other$name = other.name;
        return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigramiScript;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MigramiCategory $category = this.category;
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        MigramiScriptName $name = this.name;
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        return result;
    }
}

