/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.interfaces;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import migrami.core.interfaces.MigramiCategory;
import migrami.core.interfaces.MigramiChecksumFactory;
import migrami.core.interfaces.MigramiScript;
import migrami.core.interfaces.MigramiScriptLoader;
import toolbox.resources.interfaces.ResourceFactory;
import toolbox.resources.interfaces.ResourceName;
import toolbox.resources.interfaces.ResourcePath;
import toolbox.resources.interfaces.ResourceResolver;

class ClassPathScriptLoader
implements MigramiScriptLoader {
    private final String path;

    public ClassPathScriptLoader() {
        this.path = "migration";
    }

    public Iterable<MigramiScript> load(MigramiCategory category, MigramiChecksumFactory checksumFactory) {
        try {
            ResourcePath path = ResourcePath.create((String[])new String[]{this.path, category.path()});
            Enumeration<URL> resources = this.getClassLoader().getResources(path.toString());
            ArrayList<MigramiScript> scripts = new ArrayList<MigramiScript>();
            if (resources.hasMoreElements()) {
                URL location = resources.nextElement();
                ResourceResolver.resolver((URL)location).resolve().forEach(resourceName -> {
                    InputStream content = ResourceFactory.stream((ResourcePath)path, (ResourceName)resourceName);
                    MigramiScript script = this.toMigramiScript(category, checksumFactory, (ResourceName)resourceName, content);
                    scripts.add(script);
                });
            }
            return scripts;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    private MigramiScript toMigramiScript(MigramiCategory category, MigramiChecksumFactory checksumFactory, ResourceName resourceName, InputStream content) {
        return MigramiScript.create((MigramiCategory)category, (MigramiChecksumFactory)checksumFactory, (ResourceName)resourceName, (InputStream)content);
    }

    public ClassPathScriptLoader(String path) {
        this.path = path;
    }
}

