/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.interfaces;

import java.util.Optional;
import migrami.core.interfaces.Category;
import migrami.core.interfaces.ClassPathScriptLoader;
import migrami.core.interfaces.InMemorySnapshotRepository;
import migrami.core.interfaces.MD5ChecksumFactory;
import migrami.core.interfaces.Migrami;
import migrami.core.interfaces.MigramiCategory;
import migrami.core.interfaces.MigramiCategoryScriptLoader;
import migrami.core.interfaces.MigramiChecksumFactory;
import migrami.core.interfaces.MigramiScriptLoader;
import migrami.core.interfaces.MigramiSnapshotRepository;

public abstract class MigramiBuilder<B extends MigramiBuilder<B>> {
    protected MigramiCategoryScriptLoader scriptLoaders = new MigramiCategoryScriptLoader();
    protected Optional<MigramiSnapshotRepository> repository = Optional.empty();
    protected Optional<MigramiChecksumFactory> checksumFactory = Optional.of(MD5ChecksumFactory.valueOf());

    protected MigramiBuilder() {
    }

    public final B withChecksumfactory(MigramiChecksumFactory checksumFactory) {
        this.checksumFactory = Optional.ofNullable(checksumFactory);
        return (B)this;
    }

    public final B withClasspathScriptLoader() {
        return this.withClasspathScriptLoader("migration", Category.DEFAULT);
    }

    public final B withClasspathScriptLoader(MigramiCategory category) {
        return this.withClasspathScriptLoader("migration", category);
    }

    public final B withClasspathScriptLoader(String rootPath) {
        return this.withClasspathScriptLoader(rootPath, Category.DEFAULT);
    }

    public final B withClasspathScriptLoader(String rootPath, MigramiCategory category) {
        return this.addScriptLoader(category, new ClassPathScriptLoader(rootPath));
    }

    public final B withScriptLoader(MigramiScriptLoader loader) {
        return this.addScriptLoader(Category.DEFAULT, loader);
    }

    public final B addScriptLoader(MigramiCategory category, MigramiScriptLoader loader) {
        this.scriptLoaders.add(category, loader);
        return (B)this;
    }

    public final B withInMemorySnapshotRepository() {
        return this.withSnapshotRepository(new InMemorySnapshotRepository());
    }

    public final B withSnapshotRepository(MigramiSnapshotRepository repository) {
        this.repository = Optional.ofNullable(repository);
        return (B)this;
    }

    protected void validate() {
        String snapshotRepositoryMessage = "Snapshot repository cannot be null, it is mandatory. Do implement your own or use the built-in through Builder class";
        this.repository.orElseThrow(() -> new IllegalStateException("Snapshot repository cannot be null, it is mandatory. Do implement your own or use the built-in through Builder class"));
        String checksumFactoryMessage = "Checksum Factory cannot be null, it is mandatory. Migrami has it own built-in md5 checksum implementation, just do not configure it in Builder interface.";
        this.checksumFactory.orElseThrow(() -> new IllegalStateException("Checksum Factory cannot be null, it is mandatory. Migrami has it own built-in md5 checksum implementation, just do not configure it in Builder interface."));
    }

    public abstract Migrami build();
}

