/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.interfaces;

import lombok.Generated;
import migrami.core.interfaces.Migrami;
import migrami.core.interfaces.MigramiCategoryScriptLoader;
import migrami.core.interfaces.MigramiChecksumFactory;
import migrami.core.interfaces.MigramiScript;
import migrami.core.interfaces.MigramiSnapshot;
import migrami.core.interfaces.MigramiSnapshotRepository;

public abstract class MigramiEngine
implements Migrami {
    protected final MigramiSnapshotRepository repository;
    private final MigramiCategoryScriptLoader loader;
    private final MigramiChecksumFactory checksumFactory;

    public final void migrate() {
        this.before();
        this.loader.foreach((category, loader) -> loader.load(category, this.checksumFactory).forEach(this::baseline));
        this.after();
    }

    private void baseline(MigramiScript script) {
        MigramiSnapshot snapshot = this.repository.load(script);
        if (!snapshot.checksum().value().equals(script.checksum().value())) {
            String message = String.format("Checksum aplied to script %s is different from a stored migrated version", script.name().value());
            throw new IllegalStateException(message);
        }
        snapshot.execute(this::migrate);
        this.repository.save(snapshot);
    }

    protected void before() {
    }

    protected abstract void migrate(MigramiScript var1);

    protected void after() {
    }

    @Generated
    protected MigramiEngine(MigramiSnapshotRepository repository, MigramiCategoryScriptLoader loader, MigramiChecksumFactory checksumFactory) {
        this.repository = repository;
        this.loader = loader;
        this.checksumFactory = checksumFactory;
    }
}

