/*
 * Decompiled with CFR 0.152.
 */
package migrami.core.infra;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import migrami.core.infra.ResourceResolver;
import migrami.core.interfaces.ResourceName;

class RegularResourceResolver
implements ResourceResolver {
    private static final RegularResourceResolver valueOf = new RegularResourceResolver();
    private static final String FILE = "file";
    private static final String JAR_EXTENSION = ".jar";

    public static RegularResourceResolver valueOf() {
        return valueOf;
    }

    @Override
    public boolean accept(URL location) {
        if (location == null) {
            return false;
        }
        return FILE.equals(location.getProtocol()) && !location.getPath().endsWith(JAR_EXTENSION);
    }

    @Override
    public Iterable<ResourceName> resolve(URL location) {
        ArrayList<ResourceName> names = new ArrayList<ResourceName>();
        try (InputStream input = location.openConnection().getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String resourceName = null;
            while ((resourceName = reader.readLine()) != null) {
                names.add(ResourceName.create((String)resourceName));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return names;
    }

    private RegularResourceResolver() {
    }
}

